/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javafx.scene.control.TableView;
import sample.AboutController;
import sample.BaseReportCreator;
import sample.Controller;
import sample.archdata_t;

public class TxtReportCreator
extends BaseReportCreator {
    TxtReportCreator(TableView<archdata_t> table, long version) {
        super(table, version);
    }

    static String BuildEventsStringTextTxt(Long events) {
        if (events == 0L) {
            return "";
        }
        StringBuilder res = new StringBuilder("");
        for (int i = 0; i < 32; ++i) {
            if ((events & (long)(1 << i)) == 0L) continue;
            res.append(Controller.GetEventText(1 << i) + ";");
        }
        return res.toString();
    }

    boolean SaveToFile(String fileName, String archType, String cpxNum, String serNum, String potr, String potrAddr, String archCreated, String archDate, int ctrType, String v2Imei, Integer v2HwVer, String iccid, String contractHour) {
        StringBuilder tc = new StringBuilder();
        tc.append(archType + " \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u0430\u0440\u0445\u0438\u0432\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u0430 ");
        if (this.version == 1L) {
            tc.append("\u0413\u0421\u041f-01");
        } else {
            tc.append(TxtReportCreator.GetCompexName(ctrType));
        }
        tc.append("\r\n");
        tc.append("\u0417\u0430\u0432.\u2116 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u0430 " + cpxNum + "\r\n");
        tc.append("\u0417\u0430\u0432.\u2116 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 " + serNum + "\r\n");
        if (this.version > 1L) {
            String sImei;
            if (iccid.isEmpty()) {
                sImei = v2Imei.trim();
                tc.append("IMEI " + sImei + "\r\n");
            } else {
                sImei = v2Imei.trim();
                String sIccid = iccid.trim();
                tc.append("IMEI " + sImei + ", ICCID " + sIccid + "\r\n");
            }
            tc.append("\u041d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u041f\u041e " + TxtReportCreator.GetHwVersion(v2HwVer.longValue()) + "\r\n");
            tc.append(AboutController.GetUpVersionStr(Controller.UP_VERSION_HI, Controller.UP_VERSION_LOW, Controller.UP_VERSION_DATE) + "\r\n");
            tc.append("\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0439 \u0447\u0430\u0441: " + contractHour + "\r\n");
        }
        String sPotr = TxtReportCreator.BuildPotrStr(potr);
        String sPotrAddr = TxtReportCreator.BuildPotrStr(potrAddr);
        tc.append("\u041f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u044c: " + sPotr + "\r\n");
        tc.append("\u0410\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: " + sPotrAddr + "\r\n");
        tc.append(archCreated + "\r\n");
        tc.append("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: " + archDate + "\r\n");
        tc.append("\u0422\u0430\u0431\u043b\u0438\u0446\u0430:\r\n");
        tc.append("\u0414\u0430\u0442\u0430\t");
        tc.append("\u0414\u0430\u0432\u043b\u0435\u043d\u0438\u0435, \u043a\u041f\u0430\t");
        tc.append("\u0422\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440\u0430, \u00b0C\t");
        tc.append("K\t");
        tc.append("\u041e\u0431\u044a\u0435\u043c \u043f\u0440\u0438 \u0440.\u0443., \u043c\u00b3\t");
        tc.append("\u2211\u041e\u0431\u044a\u0435\u043c \u043f\u0440\u0438 \u0440.\u0443., \u043c\u00b3\t");
        tc.append("\u041e\u0431\u044a\u0435\u043c, \u043f\u0440\u0438\u0432. \u043a \u0441.\u0443., \u043c\u00b3\t");
        tc.append("\u2211\u041e\u0431\u044a\u0435\u043c, \u043f\u0440\u0438\u0432. \u043a \u0441.\u0443., \u043c\u00b3\t");
        tc.append("\u0412\u043e\u0437\u043c. \u043e\u0431\u044a\u0435\u043c, \u043f\u0440\u0438\u0432. \u043a \u0441.\u0443., \u043c\u00b3\t");
        tc.append("\u2211\u0412\u043e\u0437\u043c. \u043e\u0431\u044a\u0435\u043c, \u043f\u0440\u0438\u0432. \u043a \u0441.\u0443., \u043c\u00b3\t");
        tc.append("\u041e\u0448\u0438\u0431\u043a\u0438\r\n");
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (i == this.table.getItems().size() - 1) {
                tc.append("\u0418\u0442\u043e\u0433\u043e\t");
            } else {
                tc.append(TxtReportCreator.GetDateRowByType(((archdata_t)this.table.getItems().get((int)i)).archType, ((archdata_t)this.table.getItems().get((int)i)).dt) + "\t");
            }
            tc.append(String.format(archdata_t.pFormat, ((archdata_t)this.table.getItems().get((int)i)).p) + "\t");
            tc.append(String.format(archdata_t.tFormat, ((archdata_t)this.table.getItems().get((int)i)).t) + "\t");
            tc.append(String.format(archdata_t.kFormat, ((archdata_t)this.table.getItems().get((int)i)).k) + "\t");
            tc.append(String.format(archdata_t.vFormat, ((archdata_t)this.table.getItems().get((int)i)).v) + "\t");
            tc.append(String.format(archdata_t.vFormat, ((archdata_t)this.table.getItems().get((int)i)).vall) + "\t");
            tc.append(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vst) + "\t");
            tc.append(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vstall) + "\t");
            tc.append(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vsterr) + "\t");
            tc.append(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vsterrall) + "\t");
            if (i == this.table.getItems().size() - 1) {
                tc.append("");
            } else {
                tc.append(TxtReportCreator.BuildEventsStringTextTxt(((archdata_t)this.table.getItems().get((int)i)).events));
            }
            tc.append("\r\n");
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);
            writer.write(tc.toString());
            writer.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

