/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.FileOutputStream;
import java.util.ArrayList;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import sample.CRC16;
import sample.MBPacket;
import sample.MBState;
import sample.ModbusBase;

public class ModbusRTU
extends ModbusBase {
    byte[] buf;
    ArrayList<Byte> buffer = new ArrayList();
    byte[] receivedBuf;
    final int combufsize;
    Boolean command_received = false;
    int command_end_pos;
    int error_state;
    int m_ReadTimeOut = 1500;
    Double systime = 0.0;
    Long lastSysTime = 0L;
    Object readReady = new Object();
    FileOutputStream fs;

    int GetParamsFromCommand(ArrayList<Byte> Params, byte[] buf, int startIdx, int params_size) {
        int size = 0;
        for (int i = startIdx; i < params_size; ++i) {
            ++size;
            Params.add(buf[i]);
        }
        return size;
    }

    MBState simpleSend(byte Addr, byte CommandNo, ArrayList<Byte> data, int datasize) {
        this.buf = new byte[datasize + 4];
        int pos = 0;
        this.buf[pos++] = Addr;
        this.buf[pos++] = CommandNo;
        for (int i = 0; i < datasize; ++i) {
            this.buf[pos++] = data.get(i);
        }
        int crc16 = CRC16.calc(65535, this.buf, 0, pos);
        this.buf[pos] = (byte)(crc16 & 0xFF);
        this.buf[pos + 1] = (byte)(crc16 >> 8 & 0xFF);
        int size = pos + 2;
        Boolean isTimeout = false;
        try {
            System.out.println("TX: " + ModbusBase.ToHex(this.buf));
            this.cp.writeBytes(this.buf);
        }
        catch (SerialPortException e) {
            if (e.getExceptionType().indexOf("not opened") >= 0) {
                return MBState.mbPortClosed;
            }
            return MBState.mbSendFailed;
        }
        return MBState.mbOk;
    }

    int ParseCommand(byte[] buf, ArrayList<Byte> Params, Short crc16, int command_size) {
        int param_size = this.GetParamsFromCommand(Params, buf, 2, command_size - 2);
        crc16 = (short)((buf[command_size - 2] & 0xFF) << 8 | buf[command_size - 1] & 0xFF);
        return param_size;
    }

    void InitSend() throws SerialPortException {
        if (!this.cp.isOpened()) {
            this.cp.openPort();
            this.cp.setParams(57600, 8, 1, 0);
        }
    }

    @Override
    public MBState Send(MBPacket packet) {
        this.buffer.clear();
        return this.simpleSend(packet.Addr, packet.CommandNo, packet.data, packet.data.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBState Read(MBPacket packet) {
        try {
            int incrc16;
            Object object = this.readReady;
            synchronized (object) {
                Long ct = 0L;
                this.lastSysTime = System.currentTimeMillis();
                do {
                    this.readReady.wait(this.m_ReadTimeOut / 5);
                } while ((ct = Long.valueOf(System.currentTimeMillis() - this.lastSysTime)) < (long)this.m_ReadTimeOut);
                if (!this.command_received.booleanValue()) {
                    return MBState.mbReadFailed;
                }
            }
            if (this.buffer.isEmpty() || this.buffer.size() < 4) {
                return MBState.mbReadFailed;
            }
            this.command_end_pos = this.buffer.size() - 1;
            this.command_received = true;
            Byte Addr = this.receivedBuf[0];
            Byte CommandNo = this.receivedBuf[1];
            ArrayList<Byte> Params = new ArrayList<Byte>();
            Short crc16 = 0;
            int params_size = this.ParseCommand(this.receivedBuf, Params, crc16, this.command_end_pos + 1);
            int crc16_calc = CRC16.calc(65535, this.receivedBuf, this.receivedBuf.length - 2);
            if (crc16_calc == (incrc16 = (this.receivedBuf[this.receivedBuf.length - 2] & 0xFF | this.receivedBuf[this.receivedBuf.length - 1] << 8 & 0xFF00) & 0xFFFF)) {
                packet.Addr = Addr;
                packet.CommandNo = CommandNo;
                packet.data.clear();
                for (int i = 0; i < params_size; ++i) {
                    packet.data.add(Params.get(i));
                }
                return MBState.mbOk;
            }
            return MBState.mbReadFailed;
        }
        catch (InterruptedException e) {
            return MBState.mbReadFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBState SendAndReadSync(MBPacket request, MBPacket answer) {
        this.mb_lock.lock();
        MBState status = MBState.mbSendFailed;
        try {
            status = this.Send(request);
            if (status == MBState.mbOk) {
                status = this.Read(answer);
            }
        }
        finally {
            this.mb_lock.unlock();
        }
        return status;
    }

    @Override
    public Boolean isCommandReceived() {
        return this.command_received;
    }

    @Override
    public void ResetReceivedStatus() {
        this.command_received = false;
    }

    ModbusRTU(SerialPort cp, byte addr) {
        super(cp, addr);
        this.combufsize = 4100;
        try {
            cp.setEventsMask(1);
            cp.addEventListener((SerialPortEventListener)new ModbusEventListener(cp));
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    class ModbusEventListener
    implements SerialPortEventListener {
        SerialPort cp;

        public ModbusEventListener(SerialPort cp) {
            this.cp = cp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialEvent(SerialPortEvent event) {
            block12: {
                if (event.isRXCHAR()) {
                    try {
                        int incrc16;
                        int crc16;
                        int read_cnt;
                        ModbusRTU.this.lastSysTime = System.currentTimeMillis();
                        byte[] data = this.cp.readBytes();
                        if (data == null) {
                            return;
                        }
                        for (int i = 0; i < data.length; ++i) {
                            ModbusRTU.this.buffer.add(data[i]);
                            ModbusRTU.this.lastSysTime = System.currentTimeMillis();
                        }
                        ModbusRTU.this.lastSysTime = System.currentTimeMillis();
                        if (ModbusRTU.this.buffer.size() <= 4) break block12;
                        byte[] temp = new byte[ModbusRTU.this.buffer.size()];
                        ModbusRTU.this.receivedBuf = new byte[ModbusRTU.this.buffer.size()];
                        for (int i = 0; i < ModbusRTU.this.buffer.size(); ++i) {
                            temp[i] = ModbusRTU.this.buffer.get(i);
                            ModbusRTU.this.receivedBuf[i] = temp[i];
                        }
                        boolean checkCRC = true;
                        if (ModbusRTU.this.receivedBuf[1] == 111 && ModbusRTU.this.receivedBuf[2] == 0) {
                            read_cnt = ModbusRTU.this.receivedBuf[4] << 8 | ModbusRTU.this.receivedBuf[3];
                            checkCRC = ModbusRTU.this.receivedBuf.length >= (read_cnt *= 72) + 3;
                        } else if (ModbusRTU.this.receivedBuf[1] == 104 && ModbusRTU.this.receivedBuf[2] == 0) {
                            read_cnt = ModbusRTU.this.receivedBuf[4] << 8 | ModbusRTU.this.receivedBuf[3];
                            boolean bl = checkCRC = ModbusRTU.this.receivedBuf.length >= (read_cnt *= 80) + 3;
                        }
                        if (!checkCRC || (crc16 = CRC16.calc(65535, temp, temp.length - 2)) != (incrc16 = (temp[temp.length - 2] & 0xFF | temp[temp.length - 1] << 8 & 0xFF00) & 0xFFFF)) break block12;
                        Object object = ModbusRTU.this.readReady;
                        synchronized (object) {
                            System.out.println("RX: " + ModbusBase.ToHex(ModbusRTU.this.receivedBuf));
                            ModbusRTU.this.command_received = true;
                            ModbusRTU.this.lastSysTime = 0L;
                            ModbusRTU.this.readReady.notify();
                        }
                    }
                    catch (SerialPortException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

