/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.concurrent.Task;
import jssc.SerialPort;
import jssc.SerialPortException;
import sample.MBCallback;
import sample.MBPacket;
import sample.MBRequest;
import sample.MBState;
import sample.MBTable;
import sample.ModbusRTU;
import sample.TableEntry;

public class ModbusController {
    private Byte address;
    private String portName;
    Integer baudRate;
    private Boolean connected;
    private AtomicBoolean isStopped = new AtomicBoolean(false);
    private AtomicBoolean clearMBQueueEvent = new AtomicBoolean(false);
    private ModbusRTU rtu;
    private SerialPort cp;
    private MBTable mbTable;
    private MBCallback connectCB;
    private Object startStopSync = new Object();
    private PriorityBlockingQueue<MBRequest> requests = new PriorityBlockingQueue();
    Thread mbThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getConnected() {
        Boolean v = false;
        Object object = this.startStopSync;
        synchronized (object) {
            v = this.connected;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(Boolean v) {
        Object object = this.startStopSync;
        synchronized (object) {
            this.connected = v;
        }
    }

    public ModbusController(MBTable table, MBCallback cb) {
        this.connectCB = cb;
        this.mbTable = table;
        this.connected = false;
    }

    public ModbusRTU getRtu() {
        return this.rtu;
    }

    public AtomicBoolean getClearMBQueueEvent() {
        return this.clearMBQueueEvent;
    }

    public boolean AddMBRequest(MBRequest req) {
        if (this.requests.contains(req)) {
            return false;
        }
        this.requests.add(req);
        return true;
    }

    public void ProcessModbusRequest(MBPacket req, MBPacket ans) {
        Integer StartReg = 0;
        short Count = 0;
        short Value = 0;
        boolean hasError = (ans.CommandNo & 0x80) == 128;
        int command = ans.CommandNo;
        if (hasError) {
            command = command & 0xFFFFFF7F & 0xFF;
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        if (req.data.size() > 3) {
            buffer.put(req.data.get(0));
            buffer.put(req.data.get(1));
            buffer.put(req.data.get(2));
            buffer.put(req.data.get(3));
            StartReg = buffer.getShort(0) & 0xFFFF;
        }
        switch (command) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                Count = buffer.getShort(2);
                break;
            }
            case 5: 
            case 6: {
                Value = buffer.getShort(2);
            }
        }
        this.VichExecuteSlaveAnswer(command, ans.data, StartReg, Count, Value, this.mbTable);
    }

    private void VichExecuteSlaveAnswer(int command, ArrayList<Byte> inparams, Integer StartReg, short Count, short Value, MBTable table) {
        switch (command) {
            case 3: {
                this.VichReadHoldingRegistersSlaveAnswer(inparams, StartReg, Count, table.Holdings);
                break;
            }
            case 4: {
                this.VichReadInputRegistersSlaveAnswer(inparams, StartReg, Count, table.Inputs);
                break;
            }
            case 2: {
                this.VichReadDiscreteRegisterSlaveAnswer(inparams, StartReg, Count, table.Discretes);
                break;
            }
            case 6: {
                this.VichPresetSingleRegisterSlaveAnswer(inparams, StartReg, Value);
                break;
            }
            case 16: {
                this.VichPresetHoldRegistersSlaveAnswer(inparams, StartReg, Count);
                break;
            }
            case 5: {
                this.VichForceCoilRegisterSlaveAnswer(inparams, StartReg, Value);
                break;
            }
            case 1: {
                this.VichGetCoilRegisterSlaveAnswer(inparams, StartReg, Count, table.Coils);
            }
        }
    }

    private void VichGetCoilRegisterSlaveAnswer(ArrayList<Byte> inparams, Integer StartReg, short Count, ArrayList<TableEntry> Coils) {
        int cnt = inparams.get(0).byteValue();
        int ost = Count % 8;
        for (int i = 0; i < cnt; ++i) {
            int last = 8;
            if (i == cnt - 1 && ost != 0) {
                last = ost;
            }
            for (int j = 0; j < last; ++j) {
                int v = inparams.get(i + 1) & 1 << j & 0xFF;
                Integer n = StartReg;
                Integer n2 = StartReg = Integer.valueOf(StartReg + 1);
                this.SetFlagFromData(n, v, Coils, Coils.size());
            }
        }
    }

    private void SetFlagFromData(Integer Reg, int Value, ArrayList<TableEntry> coils, int size) {
        TableEntry key = new TableEntry();
        key.regNum = Reg;
        int idx = Collections.binarySearch(coils, key);
        if (idx >= 0) {
            this.SetRegFromData(coils.get(idx), (short)Value);
        }
    }

    private void VichForceCoilRegisterSlaveAnswer(ArrayList<Byte> inparams, Integer startReg, short value) {
        boolean v;
        int sh0 = inparams.get(0) & 0xFF | inparams.get(1) << 8 & 0xFF00;
        int sh1 = inparams.get(2) & 0xFF | inparams.get(3) << 8 & 0xFF00;
        boolean bl = v = sh1 == 65280;
        if (sh0 != startReg || sh1 != value) {
            // empty if block
        }
    }

    private void VichPresetHoldRegistersSlaveAnswer(ArrayList<Byte> inparams, Integer startReg, short count) {
        int sh0 = inparams.get(0) & 0xFF | inparams.get(1) << 8 & 0xFF00;
        int sh1 = inparams.get(2) & 0xFF | inparams.get(3) << 8 & 0xFF00;
        if (sh0 != startReg || sh1 != count) {
            // empty if block
        }
    }

    private void VichPresetSingleRegisterSlaveAnswer(ArrayList<Byte> inparams, Integer startReg, short value) {
        int sh0 = inparams.get(0) & 0xFF | inparams.get(1) << 8 & 0xFF00;
        int sh1 = inparams.get(2) & 0xFF | inparams.get(3) << 8 & 0xFF00;
        if (sh0 != startReg || sh1 != value) {
            // empty if block
        }
    }

    private void VichReadDiscreteRegisterSlaveAnswer(ArrayList<Byte> inparams, Integer StartReg, short Count, ArrayList<TableEntry> discretes) {
        int cnt = inparams.get(0).byteValue();
        int ost = Count % 8;
        for (int i = 0; i < cnt; ++i) {
            int last = 8;
            if (i == cnt - 1 && ost != 0) {
                last = ost;
            }
            for (int j = 0; j < last; ++j) {
                int v = inparams.get(i + 1) & 1 << j & 0xFF;
                Integer n = StartReg;
                Integer n2 = StartReg = Integer.valueOf(StartReg + 1);
                this.SetFlagFromData(n, v, discretes, discretes.size());
            }
        }
    }

    private void VichReadInputRegistersSlaveAnswer(ArrayList<Byte> inparams, Integer StartReg, short Count, ArrayList<TableEntry> inputs) {
        ByteBuffer bb = ByteBuffer.allocate(inparams.size());
        for (int i = 1; i < inparams.size(); ++i) {
            bb.put(inparams.get(i));
        }
        bb.position(0);
        this.SetRegisterValues(StartReg, Count, bb.asShortBuffer(), inputs);
    }

    private void VichReadHoldingRegistersSlaveAnswer(ArrayList<Byte> inparams, Integer StartReg, short Count, ArrayList<TableEntry> holdings) {
        ByteBuffer bb = ByteBuffer.allocate(inparams.size());
        for (int i = 1; i < inparams.size(); ++i) {
            bb.put(inparams.get(i));
        }
        bb.position(0);
        this.SetRegisterValues(StartReg, Count, bb.asShortBuffer(), holdings);
    }

    private void SetRegisterValues(Integer BaseReg, short Count, ShortBuffer shortBuffer, ArrayList<TableEntry> registers) {
        int total = BaseReg + Count;
        int ptr = 0;
        for (int reg = BaseReg.intValue(); reg < total; ++reg) {
            TableEntry key = new TableEntry();
            key.regNum = reg;
            int idx = Collections.binarySearch(registers, key);
            if (idx >= 0) {
                this.SetRegFromData(registers.get(idx), shortBuffer.get(ptr));
            }
            ++ptr;
        }
    }

    private void SetRegFromData(TableEntry tableEntry, short v) {
        tableEntry.data.val.putShort(tableEntry.offset * 2, v);
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public Byte getAddress() {
        return this.address;
    }

    public void setAddress(Byte address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean StartModbusThread(String portName, byte Addr, int speed) {
        Object object = this.startStopSync;
        synchronized (object) {
            this.portName = portName;
            this.address = Addr;
            this.baudRate = speed;
            if (this.cp != null && this.cp.isOpened()) {
                try {
                    this.cp.closePort();
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
            }
            this.cp = new SerialPort(portName);
            try {
                if (!this.cp.isOpened()) {
                    this.cp.openPort();
                    this.cp.setParams(speed, 8, 1, 0, false, false);
                    this.cp.setFlowControlMode(0);
                }
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
            this.isStopped.set(false);
            this.rtu = new ModbusRTU(this.cp, Addr);
            this.mbThread = new Thread((Runnable)((Object)new MBTask()));
            this.mbThread.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean StopModbusThread() {
        Object object = this.startStopSync;
        synchronized (object) {
            this.isStopped.set(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Connect(String portName, byte Addr, int speed) {
        Object object = this.startStopSync;
        synchronized (object) {
            this.portName = portName;
            this.address = Addr;
            this.baudRate = speed;
            if (this.cp != null && this.cp.isOpened()) {
                try {
                    this.cp.closePort();
                }
                catch (SerialPortException e) {
                    e.printStackTrace();
                }
            }
            this.cp = new SerialPort(portName);
            try {
                if (!this.cp.isOpened()) {
                    this.cp.openPort();
                    this.cp.setParams(speed, 8, 1, 0, false, false);
                    this.cp.setFlowControlMode(0);
                }
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
            this.isStopped.set(false);
            this.rtu = new ModbusRTU(this.cp, Addr);
        }
    }

    public void Disconnect() {
        try {
            if (this.cp != null && this.cp.isOpened()) {
                this.cp.closePort();
            }
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    class MBTask
    extends Task<Integer> {
        MBTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer call() throws Exception {
            try {
                boolean iterations = false;
                int conRetryCnt = 0;
                while (!ModbusController.this.isStopped.get()) {
                    MBRequest cit = null;
                    try {
                        Integer constatus;
                        MBRequest it;
                        if (ModbusController.this.clearMBQueueEvent.get()) {
                            ModbusController.this.requests.clear();
                            ModbusController.this.clearMBQueueEvent.set(false);
                        }
                        cit = it = (MBRequest)ModbusController.this.requests.poll(100L, TimeUnit.MILLISECONDS);
                        if (it == null) {
                            Thread.sleep(500L);
                            continue;
                        }
                        MBPacket p = new MBPacket();
                        MBState status = ModbusController.this.rtu.SendAndReadSync(it.packet, p);
                        if (status != MBState.mbOk) {
                            if (conRetryCnt++ > 2) {
                                constatus = 0;
                                Platform.runLater(() -> ModbusController.this.connectCB.handleAnswer(null, null, constatus));
                            }
                            if (status == MBState.mbPortClosed) {
                                ModbusController.this.isStopped.set(true);
                                break;
                            }
                            it.answered = false;
                            ModbusController.this.AddMBRequest(it);
                            continue;
                        }
                        conRetryCnt = 0;
                        constatus = 1;
                        Platform.runLater(() -> ModbusController.this.connectCB.handleAnswer(null, null, constatus));
                        MBPacket req = (MBPacket)it.packet.clone();
                        MBCallback cb = it.callback;
                        if (p.HasError().booleanValue()) {
                            it.answered = false;
                            ModbusController.this.AddMBRequest(it);
                            continue;
                        }
                        ModbusController.this.ProcessModbusRequest(req, p);
                        it.answered = true;
                        if (cb == null) continue;
                        Platform.runLater(() -> cb.handleAnswer(req, p, it.user_data));
                    }
                    catch (Exception e) {
                        if (cit != null) {
                            cit.answered = false;
                            ModbusController.this.AddMBRequest(cit);
                        }
                        e.printStackTrace();
                    }
                }
                ModbusController.this.requests.clear();
                if (ModbusController.this.cp.isOpened()) {
                    ModbusController.this.cp.closePort();
                }
                Integer constatus = -1;
                Platform.runLater(() -> ModbusController.this.connectCB.handleAnswer(null, null, constatus));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        protected void succeeded() {
            super.succeeded();
            this.updateMessage("Done!");
        }

        protected void cancelled() {
            super.cancelled();
            this.updateMessage("Cancelled!");
        }

        protected void failed() {
            super.failed();
            this.updateMessage("Failed!");
        }
    }
}

