/*
 * Decompiled with CFR 0.152.
 */
package sample;

import sample.MBCallback;
import sample.MBPacket;
import sample.priority_t;

public class MBRequest
implements Comparable<MBRequest> {
    Integer priority;
    Boolean answered;
    Object user_data;
    MBPacket packet;
    MBCallback callback;

    @Override
    public int compareTo(MBRequest o) {
        if (this.priority < o.priority) {
            return 1;
        }
        if (this.priority == o.priority) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MBRequest n = (MBRequest)obj;
        return this.priority == n.priority && this.answered == n.answered && this.packet.equals(n.packet);
    }

    public int hashCode() {
        int result = 31 * this.priority + (this.answered != false ? 37 : 41) + this.packet.hashCode() * 43;
        return result;
    }

    MBRequest() {
        this.priority = priority_t.LOW_PRIORITY;
        this.callback = null;
        this.answered = false;
        this.user_data = null;
        this.packet = new MBPacket();
    }

    MBRequest(MBPacket pack, int prior, MBCallback cb) {
        this.packet = pack;
        this.priority = prior;
        this.callback = cb;
        this.answered = false;
        this.user_data = null;
    }

    public static MBRequest PingRequest(byte addr, int prior, MBCallback cb) {
        MBPacket pack = new MBPacket();
        pack.Addr = addr;
        pack.CommandNo = (byte)65;
        pack.data = null;
        return new MBRequest(pack, prior, cb);
    }
}

