/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sample.DataType;
import sample.MBReg;
import sample.MBTable;
import sample.RegType;
import sample.TableEntry;

public class MBRegManager {
    private Map<Integer, MBReg> regs = new HashMap<Integer, MBReg>();
    private Map<String, Integer> tag2Addr = new HashMap<String, Integer>();
    private MBTable table = new MBTable();

    public Map<Integer, MBReg> GetRegs() {
        return this.regs;
    }

    public MBTable GetTable() {
        return this.table;
    }

    public Integer FindAddr(String tag) {
        return this.tag2Addr.getOrDefault(tag, -1);
    }

    private void AddReg(int addr, RegType rt, DataType dt, String tag) {
        if (this.regs.containsKey(addr)) {
            System.out.println("Addr already exists! " + addr);
        }
        this.regs.put(addr, new MBReg(addr, rt, dt, tag));
        this.tag2Addr.put(tag, addr);
    }

    public MBReg GetReg(String tag) {
        int addr = this.FindAddr(tag);
        if (addr == -1) {
            return null;
        }
        return this.regs.get(addr);
    }

    void Init() {
        this.AddReg(10000, RegType.rtInput, DataType.dtLong, "reg_code_0");
        this.AddReg(10002, RegType.rtInput, DataType.dtLong, "reg_code_1");
        this.AddReg(10004, RegType.rtInput, DataType.dtLong, "reg_code_2");
        this.AddReg(10006, RegType.rtInput, DataType.dtLong, "reg_code_3");
        this.AddReg(10008, RegType.rtInput, DataType.dtLong, "mbr_user_lic_0");
        this.AddReg(10010, RegType.rtInput, DataType.dtLong, "mbr_user_lic_1");
        this.AddReg(10012, RegType.rtInput, DataType.dtLong, "mbr_user_lic_2");
        this.AddReg(10014, RegType.rtInput, DataType.dtLong, "mbr_user_lic_3");
        this.AddReg(10016, RegType.rtInput, DataType.dtLong, "reg_code_mog_0");
        this.AddReg(10018, RegType.rtInput, DataType.dtLong, "reg_code_mog_1");
        this.AddReg(10020, RegType.rtInput, DataType.dtLong, "reg_code_mog_2");
        this.AddReg(10022, RegType.rtInput, DataType.dtLong, "reg_code_mog_3");
        this.AddReg(10024, RegType.rtInput, DataType.dtLong, "mbr_user_lic_mog_0");
        this.AddReg(10026, RegType.rtInput, DataType.dtLong, "mbr_user_lic_mog_1");
        this.AddReg(10028, RegType.rtInput, DataType.dtLong, "mbr_user_lic_mog_2");
        this.AddReg(10030, RegType.rtInput, DataType.dtLong, "mbr_user_lic_mog_3");
        this.AddReg(10500, RegType.rtInput, DataType.dtInt16, "mbr_fwupdate_error");
        this.AddReg(30000, RegType.rtInput, DataType.dtInt16, "cd_day");
        this.AddReg(30001, RegType.rtInput, DataType.dtInt16, "cd_month");
        this.AddReg(30002, RegType.rtInput, DataType.dtInt16, "cd_year");
        this.AddReg(30003, RegType.rtInput, DataType.dtInt16, "cd_hour");
        this.AddReg(30004, RegType.rtInput, DataType.dtInt16, "cd_minute");
        this.AddReg(30005, RegType.rtInput, DataType.dtInt16, "cd_second");
        this.AddReg(30006, RegType.rtInput, DataType.dtFloat, "mbr_setP");
        this.AddReg(30008, RegType.rtInput, DataType.dtFloat, "mbr_setK");
        this.AddReg(30010, RegType.rtInput, DataType.dtFloat, "mbr_setT");
        this.AddReg(30012, RegType.rtInput, DataType.dtFloat, "mbr_setTmin");
        this.AddReg(30014, RegType.rtInput, DataType.dtFloat, "mbr_setTmax");
        this.AddReg(30016, RegType.rtInput, DataType.dtFloat, "mbr_setPmin");
        this.AddReg(30018, RegType.rtInput, DataType.dtFloat, "mbr_setPmax");
        this.AddReg(30020, RegType.rtInput, DataType.dtInt16, "mbr_setContractHour");
        this.AddReg(30021, RegType.rtInput, DataType.dtInt16, "mbr_setMBAddr1");
        this.AddReg(30022, RegType.rtInput, DataType.dtInt16, "mbr_setMBSpeed1");
        this.AddReg(30023, RegType.rtInput, DataType.dtInt16, "mbr_ble_enabled");
        this.AddReg(30024, RegType.rtInput, DataType.dtInt16, "mbr_gprs_enabled");
        this.AddReg(30025, RegType.rtInput, DataType.dtInt16, "mbr_gprs_schedType");
        this.AddReg(30026, RegType.rtInput, DataType.dtInt16, "mbr_gprs_hhmm");
        this.AddReg(30027, RegType.rtInput, DataType.dtInt16, "mbr_gprs_dayOfMonth");
        this.AddReg(30028, RegType.rtInput, DataType.dtInt16, "mbr_gprs_port");
        this.AddReg(30029, RegType.rtInput, DataType.dtInt16, "mbr_gprs_usessl");
        this.AddReg(30030, RegType.rtInput, DataType.dtInt16, "mbr_gprs_timeout");
        this.AddReg(30031, RegType.rtInput, DataType.dtInt16, "mbr_setLCDOn");
        this.AddReg(30032, RegType.rtInput, DataType.dtInt16, "mbr_setRotateMenu");
        this.AddReg(30033, RegType.rtInput, DataType.dtFloat, "mbr_setKimp");
        this.AddReg(30035, RegType.rtInput, DataType.dtFloat, "mbr_setFlowMax");
        this.AddReg(30037, RegType.rtInput, DataType.dtInt16, "mbr_rtc_calib_period");
        this.AddReg(30038, RegType.rtInput, DataType.dtInt16, "mbr_rtc_calp");
        this.AddReg(30039, RegType.rtInput, DataType.dtInt16, "mbr_rtc_calm");
        this.AddReg(30040, RegType.rtInput, DataType.dtLong, "mbr_setSNcounter");
        this.AddReg(30042, RegType.rtInput, DataType.dtLong, "mbr_setSNcomplex");
        this.AddReg(30044, RegType.rtInput, DataType.dtFloat, "mbr_setVall");
        this.AddReg(30046, RegType.rtInput, DataType.dtInt16, "ro_auth_user_group");
        this.AddReg(30047, RegType.rtInput, DataType.dtInt16, "ro_auth_access_level");
        this.AddReg(30048, RegType.rtInput, DataType.dtInt16, "ro_batteryStatus");
        this.AddReg(30049, RegType.rtInput, DataType.dtFloat, "mbr_setResistValue");
        this.AddReg(30051, RegType.rtInput, DataType.dtInt16, "mbr_gprs_cmd_timeout");
        this.AddReg(30052, RegType.rtInput, DataType.dtInt16, "mbr_gprs_init_delay");
        this.AddReg(30053, RegType.rtInput, DataType.dtInt16, "mbr_gprs_reg_delay");
        this.AddReg(30054, RegType.rtInput, DataType.dtInt16, "mbr_gprs_deinit_delay");
        this.AddReg(30055, RegType.rtInput, DataType.dtInt16, "mbr_gprs_retry_count");
        this.AddReg(30056, RegType.rtInput, DataType.dtInt16, "mbr_gprs_signal_level");
        this.AddReg(30057, RegType.rtInput, DataType.dtLong, "mbr_full_version");
        this.AddReg(30059, RegType.rtInput, DataType.dtLong, "mbr_version_date");
        this.AddReg(30061, RegType.rtInput, DataType.dtInt16, "mbr_gprs_state");
        this.AddReg(30062, RegType.rtInput, DataType.dtInt16, "mbr_lastCommandIdx");
        this.AddReg(30063, RegType.rtInput, DataType.dtInt16, "mbr_use_sms");
        this.AddReg(30064, RegType.rtInput, DataType.dtInt16, "mbr_archHourlyDaysCount");
        this.AddReg(30065, RegType.rtInput, DataType.dtInt16, "mbr_archDaysCount");
        this.AddReg(30066, RegType.rtInput, DataType.dtInt16, "mbr_archMonthsCount");
        this.AddReg(30067, RegType.rtInput, DataType.dtInt16, "mbr_gprsLastSendStatus");
        this.AddReg(30068, RegType.rtInput, DataType.dtInt16, "mbr_licRegistered");
        this.AddReg(30069, RegType.rtInput, DataType.dtInt16, "mbr_gprsErrors");
        this.AddReg(30070, RegType.rtInput, DataType.dtInt16, "mbr_gprsDebugStrEnabled");
        this.AddReg(30071, RegType.rtInput, DataType.dtFloat, "mbr_temp_internal");
        this.AddReg(30073, RegType.rtInput, DataType.dtFloat, "mbr_temp_uncalib");
        this.AddReg(30075, RegType.rtInput, DataType.dtFloat, "mbr_temp_internalSaved");
        this.AddReg(30077, RegType.rtInput, DataType.dtFloat, "mbr_tempInternalOffset");
        this.AddReg(30079, RegType.rtInput, DataType.dtFloat, "mbr_vdda");
        this.AddReg(30081, RegType.rtInput, DataType.dtFloat, "mbr_mainBatteryVolt");
        this.AddReg(30083, RegType.rtInput, DataType.dtInt16, "mbr_ctrType");
        this.AddReg(30084, RegType.rtInput, DataType.dtFloat, "mbr_qcTerm");
        this.AddReg(30086, RegType.rtInput, DataType.dtInt16, "mbr_gprs_dayOfWeek");
        this.AddReg(30087, RegType.rtInput, DataType.dtInt16, "mbr_gprs_DataType");
        this.AddReg(30088, RegType.rtInput, DataType.dtLong, "mbr_storeErrorsSaved");
        this.AddReg(30090, RegType.rtInput, DataType.dtFloat, "mbr_terr_min");
        this.AddReg(30092, RegType.rtInput, DataType.dtFloat, "mbr_terr_max");
        this.AddReg(30094, RegType.rtInput, DataType.dtFloat, "mbr_calibratedTempUnlimited");
        this.AddReg(30096, RegType.rtInput, DataType.dtLong, "mbr_gprsSendCount");
        this.AddReg(30098, RegType.rtInput, DataType.dtInt16, "mbr_gprs_min_signal");
        this.AddReg(30099, RegType.rtInput, DataType.dtLong, "mbr_last_gprs_dateiso");
        this.AddReg(30101, RegType.rtInput, DataType.dtLong, "mbr_last_gprs_timeiso");
        this.AddReg(30103, RegType.rtInput, DataType.dtInt16, "mbr_emailSendEnabled");
        this.AddReg(30104, RegType.rtInput, DataType.dtInt16, "mbr_serverEnabled");
        this.AddReg(30105, RegType.rtInput, DataType.dtInt16, "mbr_serverSchedType");
        this.AddReg(30106, RegType.rtInput, DataType.dtInt16, "mbr_serverSendDataType");
        this.AddReg(30107, RegType.rtInput, DataType.dtInt16, "mbr_serverHhmm");
        this.AddReg(30108, RegType.rtInput, DataType.dtInt16, "mbr_serverDayOfMonth");
        this.AddReg(30109, RegType.rtInput, DataType.dtInt16, "mbr_serverDayOfWeek");
        this.AddReg(30110, RegType.rtInput, DataType.dtInt16, "mbr_serverRegion");
        this.AddReg(30111, RegType.rtInput, DataType.dtLong, "mbr_serverPoverkaDate");
        this.AddReg(30113, RegType.rtInput, DataType.dtInt16, "mbr_httpError");
        this.AddReg(30114, RegType.rtInput, DataType.dtInt16, "mbr_httpProgress");
        this.AddReg(30115, RegType.rtInput, DataType.dtInt16, "mbr_httpState");
        this.AddReg(30116, RegType.rtInput, DataType.dtInt16, "mbr_httpCurrentTask");
        this.AddReg(30117, RegType.rtInput, DataType.dtInt16, "mbr_httpActiveTasks");
        this.AddReg(30118, RegType.rtInput, DataType.dtInt16, "mbr_powerBoostFailed");
        this.AddReg(30119, RegType.rtInput, DataType.dtFloat, "mbr_povSet_p");
        this.AddReg(30121, RegType.rtInput, DataType.dtFloat, "mbr_povSet_t");
        this.AddReg(30123, RegType.rtInput, DataType.dtFloat, "mbr_povSet_ksgf");
        this.AddReg(30125, RegType.rtInput, DataType.dtFloat, "mbr_povSet_vrabstart");
        this.AddReg(30127, RegType.rtInput, DataType.dtInt16, "mbr_menuMode");
        this.AddReg(30128, RegType.rtInput, DataType.dtFloat, "mbr_vPov");
        this.AddReg(30130, RegType.rtInput, DataType.dtFloat, "mbr_vstPov");
        this.AddReg(30132, RegType.rtInput, DataType.dtLong, "mbr_electroPlomba");
        this.AddReg(30134, RegType.rtInput, DataType.dtInt16, "mbr_setContractDay");
        this.AddReg(30135, RegType.rtInput, DataType.dtInt16, "mbr_gprs_sendemailtxt");
        this.AddReg(30136, RegType.rtInput, DataType.dtInt16, "mbr_setRemoteSetup");
        this.AddReg(30137, RegType.rtInput, DataType.dtInt16, "mbr_gasCloudEnabled");
        this.AddReg(30138, RegType.rtInput, DataType.dtInt16, "mbr_licRegisteredMog");
        this.AddReg(30139, RegType.rtInput, DataType.dtInt16, "mbr_mog_sched_state");
        this.AddReg(30140, RegType.rtInput, DataType.dtInt16, "mbr_mog_retry");
        this.AddReg(30141, RegType.rtInput, DataType.dtLong, "mbr_mog_nextts");
        this.AddReg(30143, RegType.rtInput, DataType.dtFloat, "mbr_vbatOst");
        this.AddReg(30145, RegType.rtInput, DataType.dtInt16, "mbr_mqttEnabled");
        this.AddReg(30146, RegType.rtInput, DataType.dtInt16, "mbr_mqttUseTls");
        this.AddReg(30147, RegType.rtInput, DataType.dtInt16, "mbr_mqttAuthType");
        this.AddReg(30148, RegType.rtInput, DataType.dtLong, "totalTime");
        this.AddReg(30150, RegType.rtInput, DataType.dtFloat, "iv_t");
        this.AddReg(30152, RegType.rtInput, DataType.dtFloat, "iv_p");
        this.AddReg(30154, RegType.rtInput, DataType.dtFloat, "iv_ksgf");
        this.AddReg(30156, RegType.rtInput, DataType.dtDouble, "iv_v");
        this.AddReg(30160, RegType.rtInput, DataType.dtDouble, "iv_vst");
        this.AddReg(30164, RegType.rtInput, DataType.dtLong, "iv_events");
        this.AddReg(30166, RegType.rtInput, DataType.dtDouble, "iv_vsterr");
        this.AddReg(30170, RegType.rtInput, DataType.dtLong, "totalVstErrTime");
        this.AddReg(30172, RegType.rtInput, DataType.dtLong, "totalGprsTimer");
        this.AddReg(30174, RegType.rtInput, DataType.dtInt16, "syncTransactNum");
        this.AddReg(30175, RegType.rtInput, DataType.dtInt16, "mbr_mqttSchedType");
        this.AddReg(30176, RegType.rtInput, DataType.dtInt16, "mbr_mqttHhmm");
        this.AddReg(30177, RegType.rtInput, DataType.dtInt16, "mbr_mqttDayOfWeek");
        this.AddReg(30178, RegType.rtInput, DataType.dtInt16, "mbr_mqttDayOfMonth");
        this.AddReg(30179, RegType.rtInput, DataType.dtInt16, "mbr_mqttMoStatus");
        this.AddReg(30180, RegType.rtInput, DataType.dtInt16, "mbr_mqttMtStatus");
        this.AddReg(30181, RegType.rtInput, DataType.dtInt16, "mbr_mqttRetry");
        this.AddReg(30182, RegType.rtInput, DataType.dtLong, "mbr_mqttLastScheduledTs");
        this.AddReg(30184, RegType.rtInput, DataType.dtInt16, "mbr_mqttSendDataCnt");
        this.AddReg(30185, RegType.rtInput, DataType.dtLong, "mbr_mqttError");
        this.AddReg(30187, RegType.rtInput, DataType.dtInt16, "mbr_mqttPacketCnt");
        this.AddReg(30188, RegType.rtInput, DataType.dtInt16, "mbr_mqttTimeoutMax");
        this.AddReg(30189, RegType.rtInput, DataType.dtInt16, "mbr_mqttWaitTillNext");
        this.AddReg(30190, RegType.rtInput, DataType.dtInt16, "mbr_mqttWaitTillNextCtr");
        this.AddReg(30191, RegType.rtInput, DataType.dtInt16, "mbr_mqttTimeoutCtr");
        this.AddReg(30192, RegType.rtInput, DataType.dtInt16, "mbr_mqttServerRespStat");
        this.AddReg(30193, RegType.rtInput, DataType.dtInt16, "mbr_rtc_calib2_enabled");
        this.AddReg(30194, RegType.rtInput, DataType.dtFloat, "mbr_rtc_calib2_realfreq");
        this.AddReg(30200, RegType.rtInput, DataType.dtFloat, "ch_t");
        this.AddReg(30202, RegType.rtInput, DataType.dtFloat, "ch_p");
        this.AddReg(30204, RegType.rtInput, DataType.dtFloat, "ch_ksgf");
        this.AddReg(30206, RegType.rtInput, DataType.dtFloat, "ch_v");
        this.AddReg(30208, RegType.rtInput, DataType.dtFloat, "ch_vst");
        this.AddReg(30210, RegType.rtInput, DataType.dtFloat, "ch_vsterr");
        this.AddReg(30212, RegType.rtInput, DataType.dtLong, "ch_events");
        this.AddReg(30300, RegType.rtInput, DataType.dtFloat, "lh_t");
        this.AddReg(30302, RegType.rtInput, DataType.dtFloat, "lh_p");
        this.AddReg(30304, RegType.rtInput, DataType.dtFloat, "lh_ksgf");
        this.AddReg(30306, RegType.rtInput, DataType.dtFloat, "lh_v");
        this.AddReg(30308, RegType.rtInput, DataType.dtFloat, "lh_vst");
        this.AddReg(30310, RegType.rtInput, DataType.dtFloat, "lh_vsterr");
        this.AddReg(30312, RegType.rtInput, DataType.dtLong, "lh_events");
        this.AddReg(30400, RegType.rtInput, DataType.dtFloat, "cd_t");
        this.AddReg(30402, RegType.rtInput, DataType.dtFloat, "cd_p");
        this.AddReg(30404, RegType.rtInput, DataType.dtFloat, "cd_ksgf");
        this.AddReg(30406, RegType.rtInput, DataType.dtFloat, "cd_v");
        this.AddReg(30408, RegType.rtInput, DataType.dtFloat, "cd_vst");
        this.AddReg(30410, RegType.rtInput, DataType.dtFloat, "cd_vsterr");
        this.AddReg(30412, RegType.rtInput, DataType.dtLong, "cd_events");
        this.AddReg(30500, RegType.rtInput, DataType.dtFloat, "ld_t");
        this.AddReg(30502, RegType.rtInput, DataType.dtFloat, "ld_p");
        this.AddReg(30504, RegType.rtInput, DataType.dtFloat, "ld_ksgf");
        this.AddReg(30506, RegType.rtInput, DataType.dtFloat, "ld_v");
        this.AddReg(30508, RegType.rtInput, DataType.dtFloat, "ld_vst");
        this.AddReg(30510, RegType.rtInput, DataType.dtFloat, "ld_vsterr");
        this.AddReg(30512, RegType.rtInput, DataType.dtLong, "ld_events");
        this.AddReg(30600, RegType.rtInput, DataType.dtFloat, "cm_t");
        this.AddReg(30602, RegType.rtInput, DataType.dtFloat, "cm_p");
        this.AddReg(30604, RegType.rtInput, DataType.dtFloat, "cm_ksgf");
        this.AddReg(30606, RegType.rtInput, DataType.dtFloat, "cm_v");
        this.AddReg(30608, RegType.rtInput, DataType.dtFloat, "cm_vst");
        this.AddReg(30610, RegType.rtInput, DataType.dtFloat, "cm_vsterr");
        this.AddReg(30612, RegType.rtInput, DataType.dtLong, "cm_events");
        this.AddReg(30700, RegType.rtInput, DataType.dtFloat, "lm_t");
        this.AddReg(30702, RegType.rtInput, DataType.dtFloat, "lm_p");
        this.AddReg(30704, RegType.rtInput, DataType.dtFloat, "lm_ksgf");
        this.AddReg(30706, RegType.rtInput, DataType.dtFloat, "lm_v");
        this.AddReg(30708, RegType.rtInput, DataType.dtFloat, "lm_vst");
        this.AddReg(30710, RegType.rtInput, DataType.dtFloat, "lm_vsterr");
        this.AddReg(30712, RegType.rtInput, DataType.dtLong, "lm_events");
        this.AddReg(30760, RegType.rtInput, DataType.dtDouble, "vall_ctr");
        this.AddReg(30764, RegType.rtInput, DataType.dtDouble, "vstall_ctr");
        this.AddReg(30768, RegType.rtInput, DataType.dtDouble, "vsterrall_ctr");
        this.AddReg(31000, RegType.rtInput, DataType.dtInt16, "mbr_schedTaskActive");
        this.AddReg(31001, RegType.rtInput, DataType.dtFloat, "mbr_schedTaskDate");
        this.AddReg(31003, RegType.rtInput, DataType.dtFloat, "mbr_schedTaskTime");
        this.AddReg(31005, RegType.rtInput, DataType.dtFloat, "mbr_schedTaskPres");
        this.AddReg(31007, RegType.rtInput, DataType.dtFloat, "mbr_schedTaskTemp");
        this.AddReg(31009, RegType.rtInput, DataType.dtFloat, "mbr_schedTaskKsgf");
        this.AddReg(31011, RegType.rtInput, DataType.dtInt16, "mbr_updateTaskActive");
        this.AddReg(31012, RegType.rtInput, DataType.dtFloat, "mbr_updateTaskDate");
        this.AddReg(31014, RegType.rtInput, DataType.dtFloat, "mbr_updateTaskTime");
        this.AddReg(31016, RegType.rtInput, DataType.dtLong, "mbr_updateTaskVersion");
        this.AddReg(31018, RegType.rtInput, DataType.dtInt16, "mbr_lastServerRequestStatus");
        this.AddReg(31019, RegType.rtInput, DataType.dtInt16, "mbr_lastServerRequestError");
        this.AddReg(31020, RegType.rtInput, DataType.dtLong, "mbr_sentDataCount");
        this.AddReg(31022, RegType.rtInput, DataType.dtLong, "mbr_ostDataCount");
        this.AddReg(31024, RegType.rtInput, DataType.dtInt16, "mbr_httpTimeout");
        this.AddReg(31025, RegType.rtInput, DataType.dtInt16, "mbr_httpTimeLeft");
        this.AddReg(31026, RegType.rtInput, DataType.dtInt16, "mbr_gprsRetryCnt");
        this.AddReg(31027, RegType.rtInput, DataType.dtInt16, "mbr_gprsMaxRetry");
        this.AddReg(31028, RegType.rtInput, DataType.dtFloat, "mbr_vst_setup");
        this.AddReg(31030, RegType.rtInput, DataType.dtFloat, "mbr_vsterr_setup");
        this.AddReg(31032, RegType.rtInput, DataType.dtInt16, "mbr_gsbprocid");
        this.AddReg(31033, RegType.rtInput, DataType.dtLong, "mbr_stats_gprsSendCount");
        this.AddReg(31035, RegType.rtInput, DataType.dtLong, "mbr_stats_timeDispNewBat");
        this.AddReg(31037, RegType.rtInput, DataType.dtLong, "mbr_stats_timeGprsNewBat");
        this.AddReg(31039, RegType.rtInput, DataType.dtLong, "mbr_stats_timeUsbNewBat");
        this.AddReg(31041, RegType.rtInput, DataType.dtLong, "mbr_stats_gprsSendErr");
        this.AddReg(31043, RegType.rtInput, DataType.dtLong, "mbr_stats_gprsSendOk");
        this.AddReg(31045, RegType.rtInput, DataType.dtLong, "mbr_stats_timeDisp");
        this.AddReg(31047, RegType.rtInput, DataType.dtLong, "mbr_stats_timeGprs");
        this.AddReg(31049, RegType.rtInput, DataType.dtFloat, "mbr_stats_timeLeft");
        this.AddReg(31051, RegType.rtInput, DataType.dtLong, "mbr_stats_timeNewBat");
        this.AddReg(31053, RegType.rtInput, DataType.dtLong, "mbr_stats_timeUsb");
        this.AddReg(31055, RegType.rtInput, DataType.dtLong, "mbr_stats_timeTotal");
        this.AddReg(31057, RegType.rtInput, DataType.dtInt16, "mbr_statsSetup_gprsMaxSendCount");
        this.AddReg(31058, RegType.rtInput, DataType.dtFloat, "mbr_statsSetup_maxBatteryCap");
        this.AddReg(31060, RegType.rtInput, DataType.dtFloat, "mbr_statsSetup_tokBase");
        this.AddReg(31062, RegType.rtInput, DataType.dtFloat, "mbr_statsSetup_tokDisp");
        this.AddReg(31064, RegType.rtInput, DataType.dtFloat, "mbr_statsSetup_tokUsb");
        this.AddReg(31066, RegType.rtInput, DataType.dtInt16, "mbr_gprsWorking");
        this.AddReg(31067, RegType.rtInput, DataType.dtInt16, "mbr_bleWorking");
        this.AddReg(31068, RegType.rtInput, DataType.dtInt16, "mbr_balanceTask");
        this.AddReg(31069, RegType.rtInput, DataType.dtInt16, "mbr_isLTE");
        this.AddReg(31070, RegType.rtInput, DataType.dtFloat, "mbr_flowInstantSt");
        this.AddReg(31072, RegType.rtInput, DataType.dtFloat, "mbr_flowInstantRab");
        this.AddReg(31074, RegType.rtInput, DataType.dtLong, "mbr_lastEmailSendTs");
        this.AddReg(31076, RegType.rtInput, DataType.dtLong, "mbr_lastSrvSendTs");
        this.AddReg(31078, RegType.rtInput, DataType.dtInt16, "mbr_httpGprsRetryCnt");
        this.AddReg(8000, RegType.rtHolding, DataType.dtInt16, "auth_input_type");
        this.AddReg(8001, RegType.rtHolding, DataType.dtLong, "auth_input_passw");
        this.AddReg(8003, RegType.rtHolding, DataType.dtInt16, "auth_change_type");
        this.AddReg(8004, RegType.rtHolding, DataType.dtLong, "auth_change_passw");
        this.AddReg(8006, RegType.rtHolding, DataType.dtInt16, "auth_apply_passw");
        this.AddReg(8007, RegType.rtHolding, DataType.dtInt16, "auth_apply_change_passw");
        this.AddReg(8008, RegType.rtHolding, DataType.dtInt16, "auth_user_group");
        this.AddReg(8009, RegType.rtHolding, DataType.dtInt16, "auth_access_level");
        this.AddReg(9700, RegType.rtHolding, DataType.dtInt16, "dt_change_type");
        this.AddReg(9701, RegType.rtHolding, DataType.dtInt16, "dt_change_year");
        this.AddReg(9702, RegType.rtHolding, DataType.dtInt16, "dt_change_month");
        this.AddReg(9703, RegType.rtHolding, DataType.dtInt16, "dt_change_day");
        this.AddReg(9704, RegType.rtHolding, DataType.dtInt16, "dt_change_hour");
        this.AddReg(9705, RegType.rtHolding, DataType.dtInt16, "dt_change_minute");
        this.AddReg(9706, RegType.rtHolding, DataType.dtInt16, "dt_change_second");
        this.AddReg(9707, RegType.rtHolding, DataType.dtInt16, "dt_change_apply");
        this.AddReg(9708, RegType.rtHolding, DataType.dtInt16, "dt_change_error");
        this.AddReg(9780, RegType.rtHolding, DataType.dtInt16, "arch_req_type");
        this.AddReg(9781, RegType.rtHolding, DataType.dtInt16, "arch_req_year");
        this.AddReg(9782, RegType.rtHolding, DataType.dtInt16, "arch_req_month");
        this.AddReg(9783, RegType.rtHolding, DataType.dtInt16, "arch_req_day");
        this.AddReg(9784, RegType.rtHolding, DataType.dtInt16, "arch_req_hour");
        this.AddReg(9785, RegType.rtHolding, DataType.dtInt16, "arch_req_start_ready");
        this.AddReg(9794, RegType.rtHolding, DataType.dtInt16, "arch_ans_start_ready");
        this.AddReg(9795, RegType.rtHolding, DataType.dtInt16, "arch_ans_type");
        this.AddReg(9796, RegType.rtHolding, DataType.dtInt16, "arch_ans_year");
        this.AddReg(9797, RegType.rtHolding, DataType.dtInt16, "arch_ans_month");
        this.AddReg(9798, RegType.rtHolding, DataType.dtInt16, "arch_ans_day");
        this.AddReg(9799, RegType.rtHolding, DataType.dtInt16, "arch_ans_hour");
        this.AddReg(9800, RegType.rtHolding, DataType.dtFloat, "arch_ans_bt");
        this.AddReg(9802, RegType.rtHolding, DataType.dtLong, "arch_ans_events");
        this.AddReg(9804, RegType.rtHolding, DataType.dtFloat, "arch_ans_t");
        this.AddReg(9806, RegType.rtHolding, DataType.dtFloat, "arch_ans_p");
        this.AddReg(9808, RegType.rtHolding, DataType.dtFloat, "arch_ans_ksgf");
        this.AddReg(9810, RegType.rtHolding, DataType.dtFloat, "arch_ans_ka");
        this.AddReg(9812, RegType.rtHolding, DataType.dtFloat, "arch_ans_v");
        this.AddReg(9814, RegType.rtHolding, DataType.dtFloat, "arch_ans_vst");
        this.AddReg(9816, RegType.rtHolding, DataType.dtFloat, "arch_ans_verr");
        this.AddReg(9818, RegType.rtHolding, DataType.dtFloat, "arch_ans_vsterr");
        this.AddReg(9820, RegType.rtHolding, DataType.dtFloat, "arch_ans_vsum");
        this.AddReg(9822, RegType.rtHolding, DataType.dtFloat, "arch_ans_vstsum");
        this.AddReg(40000, RegType.rtHolding, DataType.dtFloat, "mb_setP");
        this.AddReg(40002, RegType.rtHolding, DataType.dtFloat, "mb_setK");
        this.AddReg(40004, RegType.rtHolding, DataType.dtFloat, "mb_setT");
        this.AddReg(40006, RegType.rtHolding, DataType.dtFloat, "mb_setTmin");
        this.AddReg(40008, RegType.rtHolding, DataType.dtFloat, "mb_setTmax");
        this.AddReg(40010, RegType.rtHolding, DataType.dtFloat, "mb_setPmin");
        this.AddReg(40012, RegType.rtHolding, DataType.dtFloat, "mb_setPmax");
        this.AddReg(40014, RegType.rtHolding, DataType.dtInt16, "mb_setContractHour");
        this.AddReg(40015, RegType.rtHolding, DataType.dtInt16, "mb_setMBAddr1");
        this.AddReg(40016, RegType.rtHolding, DataType.dtInt16, "mb_setMBSpeed1");
        this.AddReg(40017, RegType.rtHolding, DataType.dtInt16, "mb_ble_enabled");
        this.AddReg(40018, RegType.rtHolding, DataType.dtInt16, "mb_gprs_enabled");
        this.AddReg(40019, RegType.rtHolding, DataType.dtInt16, "mb_gprs_schedType");
        this.AddReg(40020, RegType.rtHolding, DataType.dtInt16, "mb_gprs_hhmm");
        this.AddReg(40021, RegType.rtHolding, DataType.dtInt16, "mb_gprs_dayOfMonth");
        this.AddReg(40022, RegType.rtHolding, DataType.dtInt16, "mb_gprs_port");
        this.AddReg(40023, RegType.rtHolding, DataType.dtInt16, "mb_gprs_usessl");
        this.AddReg(40024, RegType.rtHolding, DataType.dtInt16, "mb_gprs_timeout");
        this.AddReg(40025, RegType.rtHolding, DataType.dtInt16, "mb_setLCDOn");
        this.AddReg(40026, RegType.rtHolding, DataType.dtInt16, "mb_setRotateMenu");
        this.AddReg(40027, RegType.rtHolding, DataType.dtFloat, "mb_setKimp");
        this.AddReg(40029, RegType.rtHolding, DataType.dtFloat, "mb_setFlowMax");
        this.AddReg(40031, RegType.rtHolding, DataType.dtInt16, "rtc_calib_period");
        this.AddReg(40032, RegType.rtHolding, DataType.dtInt16, "rtc_calp");
        this.AddReg(40033, RegType.rtHolding, DataType.dtInt16, "rtc_calm");
        this.AddReg(40034, RegType.rtHolding, DataType.dtLong, "mb_setSNcounter");
        this.AddReg(40036, RegType.rtHolding, DataType.dtLong, "mb_setSNcomplex");
        this.AddReg(40038, RegType.rtHolding, DataType.dtFloat, "mb_setVall");
        this.AddReg(40040, RegType.rtHolding, DataType.dtFloat, "mb_calibtemp_0");
        this.AddReg(40042, RegType.rtHolding, DataType.dtFloat, "mb_calibtemp_1");
        this.AddReg(40044, RegType.rtHolding, DataType.dtFloat, "mb_uncalibratedTemp");
        this.AddReg(40046, RegType.rtHolding, DataType.dtFloat, "mb_calibratedTemp");
        this.AddReg(40048, RegType.rtHolding, DataType.dtInt16, "mb_timeCorrection");
        this.AddReg(40049, RegType.rtHolding, DataType.dtFloat, "mb_setResistValue");
        this.AddReg(40051, RegType.rtHolding, DataType.dtInt16, "mb_gprs_cmd_timeout");
        this.AddReg(40052, RegType.rtHolding, DataType.dtInt16, "mb_gprs_init_delay");
        this.AddReg(40053, RegType.rtHolding, DataType.dtInt16, "mb_gprs_reg_delay");
        this.AddReg(40054, RegType.rtHolding, DataType.dtInt16, "mb_gprs_deinit_delay");
        this.AddReg(40055, RegType.rtHolding, DataType.dtInt16, "mb_gprs_retry_count");
        this.AddReg(40056, RegType.rtHolding, DataType.dtLong, "mb_gprs_force_date");
        this.AddReg(40058, RegType.rtHolding, DataType.dtInt16, "mb_use_sms");
        this.AddReg(40059, RegType.rtHolding, DataType.dtInt16, "mb_use_debug_gprs_str");
        this.AddReg(40060, RegType.rtHolding, DataType.dtFloat, "mb_tempInternalOffset");
        this.AddReg(40062, RegType.rtHolding, DataType.dtInt16, "mb_ctrType");
        this.AddReg(40063, RegType.rtHolding, DataType.dtFloat, "mb_qcTerm");
        this.AddReg(40065, RegType.rtHolding, DataType.dtInt16, "mb_gprs_dayOfWeek");
        this.AddReg(40066, RegType.rtHolding, DataType.dtInt16, "mb_gprs_DataType");
        this.AddReg(40067, RegType.rtHolding, DataType.dtLong, "mb_fw_size");
        this.AddReg(40069, RegType.rtHolding, DataType.dtInt16, "mb_fwupdate_state");
        this.AddReg(40070, RegType.rtHolding, DataType.dtInt16, "mb_gprs_min_signal");
        this.AddReg(40071, RegType.rtHolding, DataType.dtInt16, "mb_emailSendEnabled");
        this.AddReg(40072, RegType.rtHolding, DataType.dtInt16, "mb_serverEnabled");
        this.AddReg(40073, RegType.rtHolding, DataType.dtInt16, "mb_serverSchedType");
        this.AddReg(40074, RegType.rtHolding, DataType.dtInt16, "mb_serverSendDataType");
        this.AddReg(40075, RegType.rtHolding, DataType.dtInt16, "mb_serverHhmm");
        this.AddReg(40076, RegType.rtHolding, DataType.dtInt16, "mb_serverDayOfMonth");
        this.AddReg(40077, RegType.rtHolding, DataType.dtInt16, "mb_serverDayOfWeek");
        this.AddReg(40078, RegType.rtHolding, DataType.dtInt16, "mb_serverRegion");
        this.AddReg(40079, RegType.rtHolding, DataType.dtLong, "mb_serverPoverkaDate");
        this.AddReg(40081, RegType.rtHolding, DataType.dtFloat, "mb_povSet_p");
        this.AddReg(40083, RegType.rtHolding, DataType.dtFloat, "mb_povSet_t");
        this.AddReg(40085, RegType.rtHolding, DataType.dtFloat, "mb_povSet_ksgf");
        this.AddReg(40087, RegType.rtHolding, DataType.dtFloat, "mb_povSet_vrabstart");
        this.AddReg(40089, RegType.rtHolding, DataType.dtInt16, "mb_setContractDay");
        this.AddReg(40094, RegType.rtHolding, DataType.dtInt16, "mb_gprs_sendemailtxt");
        this.AddReg(40095, RegType.rtHolding, DataType.dtInt16, "mb_setRemoteSetup");
        this.AddReg(40096, RegType.rtHolding, DataType.dtInt16, "mb_gasCloudEnabled");
        this.AddReg(40097, RegType.rtHolding, DataType.dtInt16, "mb_statsSetup_gprsMaxSendCount");
        this.AddReg(40098, RegType.rtHolding, DataType.dtFloat, "mb_statsSetup_maxBatteryCap");
        this.AddReg(40100, RegType.rtHolding, DataType.dtFloat, "mb_statsSetup_tokBase");
        this.AddReg(40102, RegType.rtHolding, DataType.dtFloat, "mb_statsSetup_tokDisp");
        this.AddReg(40104, RegType.rtHolding, DataType.dtFloat, "mb_statsSetup_tokUsb");
        this.AddReg(40106, RegType.rtHolding, DataType.dtInt16, "mb_certSize0");
        this.AddReg(40107, RegType.rtHolding, DataType.dtInt16, "mb_certSize1");
        this.AddReg(40108, RegType.rtHolding, DataType.dtInt16, "mb_certSize2");
        this.AddReg(40109, RegType.rtHolding, DataType.dtInt16, "mb_mqttEnabled");
        this.AddReg(40110, RegType.rtHolding, DataType.dtInt16, "mb_mqttUseTls");
        this.AddReg(40111, RegType.rtHolding, DataType.dtInt16, "mb_mqttAuthType");
        this.AddReg(40112, RegType.rtHolding, DataType.dtInt16, "mb_mqttSchedType");
        this.AddReg(40113, RegType.rtHolding, DataType.dtInt16, "mb_mqttHhmm");
        this.AddReg(40114, RegType.rtHolding, DataType.dtInt16, "mb_mqttDayOfWeek");
        this.AddReg(40115, RegType.rtHolding, DataType.dtInt16, "mb_mqttDayOfMonth");
        this.AddReg(40116, RegType.rtHolding, DataType.dtInt16, "mb_rtc_calib2_enabled");
        this.AddReg(40117, RegType.rtHolding, DataType.dtFloat, "mb_rtc_calib2_realfreq");
        this.AddReg(40400, RegType.rtHolding, DataType.dtLong, "user_lic_0");
        this.AddReg(40402, RegType.rtHolding, DataType.dtLong, "user_lic_1");
        this.AddReg(40404, RegType.rtHolding, DataType.dtLong, "user_lic_2");
        this.AddReg(40406, RegType.rtHolding, DataType.dtLong, "user_lic_3");
        this.AddReg(40408, RegType.rtHolding, DataType.dtLong, "user_lic_mog_0");
        this.AddReg(40410, RegType.rtHolding, DataType.dtLong, "user_lic_mog_1");
        this.AddReg(40412, RegType.rtHolding, DataType.dtLong, "user_lic_mog_2");
        this.AddReg(40414, RegType.rtHolding, DataType.dtLong, "user_lic_mog_3");
        this.AddReg(1000, RegType.rtCoil, DataType.dtInt16, "fProcessLic");
        this.AddReg(1001, RegType.rtCoil, DataType.dtInt16, "fProcessLicMog");
        this.AddReg(4000, RegType.rtCoil, DataType.dtInt16, "frtc_calib");
        this.AddReg(4001, RegType.rtCoil, DataType.dtInt16, "frtc_calib_start");
        this.AddReg(4002, RegType.rtCoil, DataType.dtInt16, "frtc_calib_stop");
        this.AddReg(4003, RegType.rtCoil, DataType.dtInt16, "fIsCountersWorking");
        this.AddReg(4005, RegType.rtCoil, DataType.dtInt16, "fApplyCOMAddr1");
        this.AddReg(4006, RegType.rtCoil, DataType.dtInt16, "fSaveSettings");
        this.AddReg(4007, RegType.rtCoil, DataType.dtInt16, "fsaveSerialNumbers");
        this.AddReg(4008, RegType.rtCoil, DataType.dtInt16, "fsaveEncoderSetup");
        this.AddReg(4009, RegType.rtCoil, DataType.dtInt16, "fClearEEPROM");
        this.AddReg(4010, RegType.rtCoil, DataType.dtInt16, "fClearARCH");
        this.AddReg(4011, RegType.rtCoil, DataType.dtInt16, "fsaveSystemSettings");
        this.AddReg(4012, RegType.rtCoil, DataType.dtInt16, "fsaveCalibrationCoefs");
        this.AddReg(4013, RegType.rtCoil, DataType.dtInt16, "fresetCalibrationCoefs");
        this.AddReg(4014, RegType.rtCoil, DataType.dtInt16, "fTimeCorrection");
        this.AddReg(4015, RegType.rtCoil, DataType.dtInt16, "fGRPSSchedReset");
        this.AddReg(4016, RegType.rtCoil, DataType.dtInt16, "fGRPSForceSend");
        this.AddReg(4017, RegType.rtCoil, DataType.dtInt16, "fCalibTemp0");
        this.AddReg(4018, RegType.rtCoil, DataType.dtInt16, "fCalibTemp1");
        this.AddReg(4019, RegType.rtCoil, DataType.dtInt16, "fTestLCD");
        this.AddReg(4020, RegType.rtCoil, DataType.dtInt16, "fResetMagnetDetected");
        this.AddReg(4021, RegType.rtCoil, DataType.dtInt16, "fResetBoxOpened");
        this.AddReg(4022, RegType.rtCoil, DataType.dtInt16, "fResetMaxFlowDetected");
        this.AddReg(4023, RegType.rtCoil, DataType.dtInt16, "fResetTempLimitDetected");
        this.AddReg(4024, RegType.rtCoil, DataType.dtInt16, "fResetInvalidADCDetected");
        this.AddReg(4025, RegType.rtCoil, DataType.dtInt16, "fResetCalibErrDetected");
        this.AddReg(4026, RegType.rtCoil, DataType.dtInt16, "fsavePotreb");
        this.AddReg(4027, RegType.rtCoil, DataType.dtInt16, "fServerTest");
        this.AddReg(4028, RegType.rtCoil, DataType.dtInt16, "fSendGetServerTask");
        this.AddReg(4029, RegType.rtCoil, DataType.dtInt16, "fServerTestForce");
        this.AddReg(4030, RegType.rtCoil, DataType.dtInt16, "fStartPoverka");
        this.AddReg(4031, RegType.rtCoil, DataType.dtInt16, "fStopPoverka");
        this.AddReg(4032, RegType.rtCoil, DataType.dtInt16, "fForcePoverka");
        this.AddReg(4033, RegType.rtCoil, DataType.dtInt16, "fSoftReset");
        this.AddReg(4034, RegType.rtCoil, DataType.dtInt16, "fEmailTestForce");
        this.AddReg(4037, RegType.rtCoil, DataType.dtInt16, "fReplaceBattery");
        this.AddReg(4038, RegType.rtCoil, DataType.dtInt16, "fForceGasCloudTest");
        this.AddReg(4039, RegType.rtCoil, DataType.dtInt16, "fReadBalance");
        this.AddReg(4040, RegType.rtCoil, DataType.dtInt16, "fUpdateCert0");
        this.AddReg(4041, RegType.rtCoil, DataType.dtInt16, "fUpdateCert1");
        this.AddReg(4042, RegType.rtCoil, DataType.dtInt16, "fUpdateCert2");
        this.AddReg(4043, RegType.rtCoil, DataType.dtInt16, "fForceMqttTest");
        this.AddReg(4044, RegType.rtCoil, DataType.dtInt16, "frtc_calib2");
        this.AddReg(4045, RegType.rtCoil, DataType.dtInt16, "fCancelGprsSend");
    }

    void InitModbusTables() {
        this.table.Holdings.clear();
        this.table.Inputs.clear();
        this.table.Coils.clear();
        this.table.Discretes.clear();
        for (Map.Entry<Integer, MBReg> entry : this.regs.entrySet()) {
            ArrayList<TableEntry> pt = null;
            MBReg reg = entry.getValue();
            switch (reg.regType) {
                case rtInput: {
                    pt = this.table.Inputs;
                    break;
                }
                case rtHolding: {
                    pt = this.table.Holdings;
                    break;
                }
                case rtCoil: {
                    pt = this.table.Coils;
                    break;
                }
                case rtDiscrete: {
                    pt = this.table.Discretes;
                }
            }
            if (pt == null) continue;
            int regsize = reg.GetBufSize();
            for (int j = 0; j < regsize; ++j) {
                pt.add(new TableEntry(reg.addr + j, reg, j));
            }
        }
        Collections.sort(this.table.Inputs);
        Collections.sort(this.table.Holdings);
        Collections.sort(this.table.Coils);
        Collections.sort(this.table.Discretes);
    }
}

