/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.nio.ByteBuffer;
import sample.DataType;
import sample.RegType;

public class MBReg
implements Comparable<MBReg> {
    ByteBuffer val;
    int addr;
    RegType regType;
    DataType dataType;
    String tag;

    MBReg(int addr, RegType regType, DataType dataType, String tag) {
        this.addr = addr;
        this.regType = regType;
        this.dataType = dataType;
        this.tag = tag;
        switch (dataType) {
            case dtInt16: {
                this.val = ByteBuffer.allocate(2);
                break;
            }
            case dtFloat: 
            case dtLong: {
                this.val = ByteBuffer.allocate(4);
                break;
            }
            case dtDouble: {
                this.val = ByteBuffer.allocate(8);
            }
        }
    }

    @Override
    public int compareTo(MBReg o) {
        if (this.addr == o.addr) {
            return this.regType.compareTo(o.regType);
        }
        return Integer.compare(this.addr, o.addr);
    }

    public boolean equals(Object obj) {
        MBReg r = (MBReg)obj;
        return this.addr == r.addr && this.regType.compareTo(r.regType) == 0;
    }

    static int GetBufSize(DataType dt) {
        switch (dt) {
            case dtInt16: 
            case dtChar: {
                return 1;
            }
            case dtFloat: {
                return 2;
            }
            case dtLong: {
                return 2;
            }
            case dtDouble: {
                return 4;
            }
        }
        return 0;
    }

    int GetBufSize() {
        return MBReg.GetBufSize(this.dataType);
    }

    Integer AsInt() {
        this.val.position(0);
        if (this.dataType == DataType.dtInt16) {
            return new Integer(this.val.getShort());
        }
        this.val.position(0);
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(this.val.get(2));
        bb.put(this.val.get(3));
        bb.put(this.val.get(0));
        bb.put(this.val.get(1));
        bb.position(0);
        return bb.getInt();
    }

    Double AsDouble() {
        this.val.position(0);
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(this.val.get(6));
        bb.put(this.val.get(7));
        bb.put(this.val.get(4));
        bb.put(this.val.get(5));
        bb.put(this.val.get(2));
        bb.put(this.val.get(3));
        bb.put(this.val.get(0));
        bb.put(this.val.get(1));
        bb.position(0);
        return bb.getDouble();
    }

    Float AsFloat() {
        this.val.position(0);
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.put(this.val.get(2));
        bb.put(this.val.get(3));
        bb.put(this.val.get(0));
        bb.put(this.val.get(1));
        bb.position(0);
        return Float.valueOf(bb.getFloat());
    }

    MBReg SetFloat(Float f) {
        this.val.position(0);
        this.val.putFloat(f.floatValue());
        this.val.position(0);
        return this;
    }

    void SetDouble(Double d) {
        this.val.position(0);
        this.val.putDouble(d);
        this.val.position(0);
    }

    MBReg SetInt16(Short i16) {
        this.val.position(0);
        this.val.putShort(i16);
        this.val.position(0);
        return this;
    }

    MBReg SetInt16(Integer i16) {
        this.val.position(0);
        this.val.putShort(i16.shortValue());
        this.val.position(0);
        return this;
    }

    MBReg SetInt32(Integer i32) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i32);
        bb.position(0);
        this.val.position(0);
        this.val.put(bb.get(2));
        this.val.put(bb.get(3));
        this.val.put(bb.get(0));
        this.val.put(bb.get(1));
        this.val.position(0);
        return this;
    }

    public Long AsLong() {
        return Integer.toUnsignedLong(this.AsInt());
    }
}

