/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import sample.CRC16;
import sample.DateISOHelper;
import sample.GprsFileMetaInfo;
import sample.archdata_t;
import sample.storedata_t;

public class GprsArchCreator {
    List<File> files;
    GprsFileMetaInfo loadedMetaInfo;

    GprsArchCreator(List<File> files) {
        this.files = files;
        this.loadedMetaInfo = null;
    }

    GprsFileMetaInfo GetLoadedMetaInfo() {
        return this.loadedMetaInfo;
    }

    boolean ValidateFiles() {
        return true;
    }

    List<String> GetDiffs() {
        return new ArrayList<String>();
    }

    public static GprsFileMetaInfo ExtractMetaInfo(byte[] data) {
        GprsFileMetaInfo mi = new GprsFileMetaInfo();
        String mdata = new String(data, StandardCharsets.US_ASCII);
        mi.mts = mdata.indexOf("MTS");
        mi.mte = mdata.indexOf("MTE");
        if (mi.mts != 0 || mi.mte < 3) {
            return null;
        }
        int allocSize = mi.mte - mi.mts + 3;
        ByteBuffer metabuf = ByteBuffer.allocate(allocSize);
        metabuf.put(data, 0, allocSize);
        metabuf.position(0);
        mi.version = Integer.reverseBytes(metabuf.getInt(3));
        mi.id = new String(data, 7, 10);
        mi.corrNum = Integer.reverseBytes(metabuf.getInt(17));
        mi.cpxNum = Integer.reverseBytes(metabuf.getInt(21));
        mi.potreb = new String(data, 25, 129, StandardCharsets.UTF_8);
        mi.potrebAddr = new String(data, 154, 129, StandardCharsets.UTF_8);
        mi.loadDate = LocalDate.of((int)Short.reverseBytes(metabuf.getShort(287)), data[286], (int)data[285]);
        mi.contractHour = data[289];
        mi.archType = data[290];
        mi.schedType = data[291];
        mi.loadedByType = data[292];
        long stk = Integer.reverseBytes(metabuf.getInt(293));
        long enk = Integer.reverseBytes(metabuf.getInt(297));
        if (mi.version >= 1L && mi.version < 3L) {
            if (mi.archType == 0) {
                mi.stkh = stk;
                mi.enkh = enk;
            } else if (mi.archType == 1) {
                mi.stkd = stk;
                mi.enkd = enk;
            } else if (mi.archType == 2) {
                mi.stkm = stk;
                mi.enkm = enk;
            }
        } else if (mi.version >= 3L) {
            mi.stkh = stk;
            mi.enkh = enk;
        }
        mi.aesKey = new byte[16];
        metabuf.position(301);
        metabuf.get(mi.aesKey);
        mi.nodeSize = 0;
        mi.forceSend = 0;
        if (mi.version >= 2L) {
            metabuf.position(317);
            mi.imei = new String(data, 318, 32, StandardCharsets.US_ASCII);
            mi.ctrType = Short.reverseBytes(metabuf.getShort(350));
            mi.hwVersion = Integer.reverseBytes(metabuf.getInt(352));
        }
        if (mi.version >= 3L) {
            mi.nodeSize = Short.reverseBytes(metabuf.getShort(356));
            mi.forceSend = data[358];
            mi.stkh = stk;
            mi.enkh = enk;
            mi.stkd = Integer.reverseBytes(metabuf.getInt(359));
            mi.enkd = Integer.reverseBytes(metabuf.getInt(363));
            mi.stkm = Integer.reverseBytes(metabuf.getInt(367));
            mi.enkm = Integer.reverseBytes(metabuf.getInt(371));
        }
        if (mi.version >= 4L) {
            metabuf.position(379);
            mi.iccid = new String(data, 379, 32, StandardCharsets.US_ASCII);
        }
        return mi;
    }

    private static void addData(ArrayList<Byte> buf, Long val) {
        byte[] bs = ByteBuffer.allocate(4).putInt(Integer.reverseBytes(val.intValue())).array();
        for (int i = 0; i < bs.length; ++i) {
            buf.add(bs[i]);
        }
    }

    private static void addData(ArrayList<Byte> buf, Short val) {
        byte[] bs = ByteBuffer.allocate(2).putShort(Short.reverseBytes(val)).array();
        for (int i = 0; i < bs.length; ++i) {
            buf.add(bs[i]);
        }
    }

    public static byte[] ToByteBuffer(GprsFileMetaInfo mi, byte loadedType, long stkh, long enkh, long stkd, long enkd, long stkm, long enkm) throws Exception {
        int i;
        int i2;
        int len;
        ArrayList<Byte> buf = new ArrayList<Byte>();
        byte[] bs = "MTS".getBytes(StandardCharsets.US_ASCII);
        for (int i3 = 0; i3 < bs.length; ++i3) {
            buf.add(bs[i3]);
        }
        GprsArchCreator.addData(buf, mi.version);
        bs = mi.id.getBytes(StandardCharsets.US_ASCII);
        boolean versionSupported = false;
        if (mi.version >= 1L) {
            len = 10;
            for (i2 = 0; i2 < len; ++i2) {
                buf.add(i2 < bs.length ? bs[i2] : (byte)0);
            }
            GprsArchCreator.addData(buf, mi.corrNum);
            GprsArchCreator.addData(buf, mi.cpxNum);
            bs = mi.potreb.getBytes(StandardCharsets.UTF_8);
            len = 129;
            for (i2 = 0; i2 < len; ++i2) {
                buf.add(i2 < bs.length ? bs[i2] : (byte)0);
            }
            bs = mi.potrebAddr.getBytes(StandardCharsets.UTF_8);
            len = 129;
            for (i2 = 0; i2 < len; ++i2) {
                buf.add(i2 < bs.length ? bs[i2] : (byte)0);
            }
            buf.add((byte)0);
            buf.add((byte)0);
            buf.add(new Integer(mi.loadDate.getDayOfMonth()).byteValue());
            buf.add(new Integer(mi.loadDate.getMonthValue()).byteValue());
            GprsArchCreator.addData(buf, new Integer(mi.loadDate.getYear()).shortValue());
            buf.add(mi.contractHour);
            buf.add(mi.archType);
            buf.add(mi.schedType);
            buf.add(loadedType);
            if (mi.version >= 1L && mi.version < 3L) {
                if (mi.archType == 0) {
                    GprsArchCreator.addData(buf, stkh);
                    GprsArchCreator.addData(buf, enkh);
                } else if (mi.archType == 1) {
                    GprsArchCreator.addData(buf, stkd);
                    GprsArchCreator.addData(buf, enkd);
                } else if (mi.archType == 2) {
                    GprsArchCreator.addData(buf, stkm);
                    GprsArchCreator.addData(buf, enkm);
                }
            } else if (mi.version >= 3L) {
                GprsArchCreator.addData(buf, stkh);
                GprsArchCreator.addData(buf, enkh);
            }
            if (mi.aesKey == null) {
                mi.aesKey = new byte[16];
                new Random().nextBytes(mi.aesKey);
            }
            for (i2 = 0; i2 < mi.aesKey.length; ++i2) {
                buf.add(mi.aesKey[i2]);
            }
            buf.add((byte)0);
            versionSupported = true;
        }
        if (mi.version >= 2L) {
            bs = mi.imei.getBytes(StandardCharsets.US_ASCII);
            len = 32;
            for (i2 = 0; i2 < len; ++i2) {
                buf.add(i2 < bs.length ? bs[i2] : (byte)0);
            }
            GprsArchCreator.addData(buf, mi.ctrType);
            GprsArchCreator.addData(buf, mi.hwVersion);
            versionSupported = true;
        }
        if (mi.version >= 3L) {
            GprsArchCreator.addData(buf, mi.nodeSize);
            buf.add(mi.forceSend);
            GprsArchCreator.addData(buf, stkd);
            GprsArchCreator.addData(buf, enkd);
            GprsArchCreator.addData(buf, stkm);
            GprsArchCreator.addData(buf, enkm);
            versionSupported = true;
        }
        if (mi.version >= 4L) {
            GprsArchCreator.addData(buf, 0L);
            bs = mi.iccid.getBytes(StandardCharsets.US_ASCII);
            len = 32;
            for (i2 = 0; i2 < len; ++i2) {
                buf.add(i2 < bs.length ? bs[i2] : (byte)0);
            }
            versionSupported = true;
        }
        if (mi.version >= 3L) {
            int written = buf.size();
            int ost = written % 3;
            for (int i4 = 0; ost != 0 && i4 < 3 - ost; ++i4) {
                buf.add((byte)0);
            }
        }
        if (!versionSupported) {
            throw new Exception("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043c\u0435\u0442\u0430\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 " + Long.toString(mi.version));
        }
        bs = "MTE".getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < bs.length; ++i) {
            buf.add(bs[i]);
        }
        bs = new byte[buf.size()];
        for (i = 0; i < buf.size(); ++i) {
            bs[i] = buf.get(i);
        }
        return bs;
    }

    public void LoadPartData(int datasize, int startPos, byte[] data, GprsFileMetaInfo mi, byte archType, ArrayList<ArrayList<archdata_t>> results) {
        int read_cnt;
        int recordSize;
        HashSet<archdata_t> result = new HashSet<archdata_t>();
        ByteBuffer abb = ByteBuffer.allocate(datasize);
        for (int p = 0; p < datasize; ++p) {
            abb.put(data[startPos + p]);
        }
        abb.position(0);
        int n = recordSize = datasize % 80 == 0 ? 80 : 72;
        if (mi.version >= 3L) {
            recordSize = mi.nodeSize;
        }
        if ((read_cnt = datasize / recordSize) > 1) {
            recordSize = this.DetermineRecordSize(abb, recordSize, datasize);
            read_cnt = datasize / recordSize;
        }
        int maxReadSize = 0;
        switch (archType) {
            case 0: {
                maxReadSize = 2400;
                break;
            }
            case 1: {
                maxReadSize = 180;
                break;
            }
            case 2: {
                maxReadSize = 6;
            }
        }
        if (read_cnt > maxReadSize) {
            recordSize = 80;
            read_cnt = maxReadSize;
        }
        storedata_t sdata = null;
        ArrayList<archdata_t> resPart = results.get(archType);
        for (int k = 0; k < read_cnt; ++k) {
            sdata = storedata_t.FromBuffer(abb, k * recordSize);
            byte[] arr = new byte[64];
            abb.position(k * recordSize);
            abb.get(arr);
            abb.position(0);
            Integer crc16c = CRC16.calc(65535, arr);
            archdata_t sd = new archdata_t();
            try {
                sd.dt = DateISOHelper.iso_to_date(sdata.key);
                if (sdata.crc == crc16c.shortValue()) {
                    sd.isInited = true;
                    sd.p = Float.valueOf(sdata.p);
                    sd.t = Float.valueOf(sdata.t);
                    sd.k = Float.valueOf(sdata.ksgf);
                    sd.v = Float.valueOf(sdata.v);
                    sd.vst = Float.valueOf(sdata.vst);
                    sd.vsterr = Float.valueOf(sdata.vsterr);
                    sd.events = sdata.events;
                    sd.totalTime = sdata.totalTime;
                    sd.vall = sdata.vall;
                    sd.vstall = sdata.vstall;
                    sd.vsterrall = sdata.vsterrall;
                    sd.crc = sdata.crc;
                    sd.archType = archType;
                    long stk = 0L;
                    long enk = 0L;
                    if (archType == 0) {
                        stk = mi.stkh;
                        enk = mi.enkh;
                    } else if (archType == 1) {
                        stk = mi.stkd;
                        enk = mi.enkd;
                    } else if (archType == 2) {
                        stk = mi.stkm;
                        enk = mi.enkm;
                    }
                    if (mi.version < 3L && stk != 0L && enk != 0L && ((long)sdata.key < stk || (long)sdata.key > enk)) {
                        System.out.println("LoadArch: sdata: " + sdata.key + " not matched to loading range: " + stk + " .. " + enk);
                        continue;
                    }
                    if (result.contains(sd)) continue;
                    result.add(sd);
                    resPart.add(sd);
                    continue;
                }
                sd.isInited = false;
                continue;
            }
            catch (DateTimeException ex) {
                sd.dt = LocalDateTime.of(2000, 1, 1, 12, 0, 0);
                sd.isInited = false;
                sd.crc = 64;
            }
        }
    }

    private int DetermineRecordSize(ByteBuffer abb, int recordSize, int abblen) {
        byte[] arr = new byte[64];
        abb.position(80);
        abb.get(arr);
        abb.position(80);
        storedata_t sdata1 = null;
        Integer crc16c = 0;
        boolean useCalcedCrc = false;
        if (abblen >= 160) {
            sdata1 = storedata_t.FromBuffer(abb, 80);
            crc16c = CRC16.calc(65535, arr);
            useCalcedCrc = true;
        }
        if (useCalcedCrc && sdata1.crc == crc16c.shortValue()) {
            return 80;
        }
        abb.position(72);
        abb.get(arr);
        abb.position(72);
        storedata_t sdata2 = storedata_t.FromBuffer(abb, 72);
        Integer crc16c2 = CRC16.calc(65535, arr);
        if (sdata2.crc == crc16c2.shortValue()) {
            return 72;
        }
        return recordSize;
    }

    public ArrayList<ArrayList<archdata_t>> LoadArch() throws Exception {
        HashMap<String, GprsFileMetaInfo> metaInfoList = new HashMap<String, GprsFileMetaInfo>();
        GprsFileMetaInfo baseMetaInfo = null;
        String baseFileName = "";
        ArrayList<ArrayList<archdata_t>> resArr = new ArrayList<ArrayList<archdata_t>>();
        resArr.add(new ArrayList());
        resArr.add(new ArrayList());
        resArr.add(new ArrayList());
        for (int i = 0; i < this.files.size(); ++i) {
            int datasize;
            File file = this.files.get(i);
            byte[] data = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            GprsFileMetaInfo mi = GprsArchCreator.ExtractMetaInfo(data);
            metaInfoList.put(file.getAbsolutePath(), mi);
            if (baseMetaInfo == null) {
                baseMetaInfo = mi;
                baseFileName = file.getAbsolutePath();
            } else if (mi.compareTo(baseMetaInfo) != 0) {
                String message = "\u0424\u0430\u0439\u043b\u044b \u0441 \u0440\u0430\u0437\u043d\u044b\u0445 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043f\u043e\u043c\u0435\u0449\u0435\u043d\u044b \u0432 \u043e\u0434\u0438\u043d \u043e\u0442\u0447\u0435\u0442.\r\n\u0424\u0430\u0439\u043b 1: " + baseFileName + "\r\n\u0424\u0430\u0439\u043b 2: " + file.getAbsolutePath();
                throw new Exception(message);
            }
            if (mi.version >= 1L && mi.version < 3L) {
                int datasize2 = data.length - (mi.mte + 3 - mi.mts);
                GprsArchCreator.CryptData(data, mi.mte + 3, datasize2, mi.aesKey, 0);
                this.LoadPartData(datasize2, mi.mte + 3, data, mi, baseMetaInfo.archType, resArr);
                continue;
            }
            if (mi.version < 3L) continue;
            String mdata = new String(data, StandardCharsets.US_ASCII);
            int st = mdata.indexOf("ARCHHOURB");
            int en = mdata.indexOf("ARCHHOURE");
            int shift = 0;
            if (st >= 0 && en >= 0 && (datasize = en - (st + 9)) > 0) {
                shift = GprsArchCreator.CryptData(data, st + 9, datasize, mi.aesKey, shift);
                this.LoadPartData(datasize, st + 9, data, mi, (byte)0, resArr);
            }
            st = mdata.indexOf("ARCHDAY_B");
            en = mdata.indexOf("ARCHDAY_E");
            if (st >= 0 && en >= 0 && (datasize = en - (st + 9)) > 0) {
                shift = GprsArchCreator.CryptData(data, st + 9, datasize, mi.aesKey, shift);
                this.LoadPartData(datasize, st + 9, data, mi, (byte)1, resArr);
            }
            st = mdata.indexOf("ARCHMON_B");
            en = mdata.indexOf("ARCHMON_E");
            if (st < 0 || en < 0 || (datasize = en - (st + 9)) <= 0) continue;
            shift = GprsArchCreator.CryptData(data, st + 9, datasize, mi.aesKey, shift);
            this.LoadPartData(datasize, st + 9, data, mi, (byte)2, resArr);
        }
        this.loadedMetaInfo = baseMetaInfo;
        Collections.sort((List)resArr.get(0));
        Collections.sort((List)resArr.get(1));
        Collections.sort((List)resArr.get(2));
        return resArr;
    }

    public static archdata_t saveDay(ArrayList<archdata_t> day1) {
        assert (day1.size() == 24);
        archdata_t vv = new archdata_t(DateISOHelper.date_to_iso(day1.get((int)0).dt.getYear(), day1.get((int)0).dt.getMonthValue(), day1.get((int)0).dt.getDayOfMonth(), 0), 0.0f, 0.0f, 0.0f, 0.0f, 0.0, 0.0f, 0.0, 0.0f, 0.0, 0L);
        vv.isInited = true;
        vv.archType = 1;
        for (int i = 0; i < day1.size(); ++i) {
            archdata_t v2 = day1.get(i);
            vv.vstall = v2.vstall;
            vv.vall = v2.vall;
            vv.vsterrall = v2.vsterrall;
            vv.totalTime = v2.totalTime;
            archdata_t archdata_t2 = vv;
            Float.valueOf(archdata_t2.v.floatValue() + v2.v.floatValue());
            archdata_t2.v = archdata_t2.v;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.vst.floatValue() + v2.vst.floatValue());
            archdata_t2.vst = archdata_t2.vst;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.vsterr.floatValue() + v2.vsterr.floatValue());
            archdata_t2.vsterr = archdata_t2.vsterr;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.bt.floatValue() + v2.bt.floatValue());
            archdata_t2.bt = archdata_t2.bt;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.t.floatValue() + v2.t.floatValue());
            archdata_t2.t = archdata_t2.t;
            archdata_t2 = vv;
            Long.valueOf(archdata_t2.events | v2.events);
            archdata_t2.events = archdata_t2.events;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.k.floatValue() + v2.k.floatValue());
            archdata_t2.k = archdata_t2.k;
            archdata_t2 = vv;
            Float.valueOf(archdata_t2.p.floatValue() + v2.p.floatValue());
            archdata_t2.p = archdata_t2.p;
        }
        archdata_t archdata_t3 = vv;
        archdata_t3.p = Float.valueOf(archdata_t3.p.floatValue() / (float)day1.size());
        archdata_t3 = vv;
        archdata_t3.t = Float.valueOf(archdata_t3.t.floatValue() / (float)day1.size());
        archdata_t3 = vv;
        archdata_t3.k = Float.valueOf(archdata_t3.k.floatValue() / (float)day1.size());
        return vv;
    }

    public static int CryptData(byte[] data, int st, int len, byte[] aesKey, int shift) {
        for (int i = 0; i < len; ++i) {
            Integer r = data[st + i] ^ aesKey[shift];
            data[st + i] = r.byteValue();
            if (++shift < 16) continue;
            shift = 0;
            for (int j = 0; j < 16; ++j) {
                if (aesKey[j] == 255) {
                    aesKey[j] = 0;
                    continue;
                }
                int n = j;
                aesKey[n] = (byte)(aesKey[n] + 1);
            }
        }
        return shift;
    }
}

