/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanXPathExecuter
implements JRXPathExecuter {
    public static final String EXCEPTION_MESSAGE_KEY_XPATH_SELECTION_FAILURE = "util.xml.xalan.xpath.selection.failure";
    private CachedXPathAPI xpathAPI = new CachedXPathAPI();

    @Override
    public NodeList selectNodeList(Node contextNode, String expression) throws JRException {
        try {
            return this.xpathAPI.selectNodeList(contextNode, expression);
        }
        catch (TransformerException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_XPATH_SELECTION_FAILURE, new Object[]{expression}, e);
        }
    }

    @Override
    public Object selectObject(Node contextNode, String expression) throws JRException {
        try {
            Object value;
            XObject object = this.xpathAPI.eval(contextNode, expression);
            switch (object.getType()) {
                case 4: {
                    value = object.nodeset().nextNode();
                    break;
                }
                case 1: {
                    value = object.bool() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    value = new Double(object.num());
                    break;
                }
                default: {
                    value = object.str();
                }
            }
            return value;
        }
        catch (TransformerException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_XPATH_SELECTION_FAILURE, new Object[]{expression}, e);
        }
    }
}

