/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.FillContainerContext;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillBreak;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JROriginProvider;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.StyleUtil;

public abstract class JRFillElementContainer
extends JRFillElementGroup
implements FillContainerContext {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements;
    private JRFillElement[] stretchElements;
    private JRFillElement[] bandBottomElements;
    private JRFillElement[] removableElements;
    protected boolean willOverflowWithElements;
    protected boolean willOverflowWithWhiteSpace;
    protected boolean isOverflow;
    protected boolean currentOverflowWithElements;
    protected boolean currentOverflowWithWhiteSpace;
    private boolean currentOverflowAllowed;
    private int stretchHeight;
    private int firstY;
    protected boolean atLeastOneElementIsToPrint;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected JRFillElement[] deepElements;
    protected Set<JRStyle> stylesToEvaluate = new HashSet<JRStyle>();
    protected Map<JRStyle, JRStyle> evaluatedStyles = new HashMap<JRStyle, JRStyle>();
    protected boolean hasPrintWhenOverflowElement;
    private final boolean legacyElementStretchEnabled;

    protected JRFillElementContainer(JRBaseFiller filler, JRElementGroup container, JRFillObjectFactory factory) {
        super(container, factory);
        boolean depFlag;
        this.expressionEvaluator = factory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = filler;
        this.legacyElementStretchEnabled = depFlag = filler.getFillContext().isLegacyElementStretchEnabled();
    }

    protected JRFillElementContainer(JRFillElementContainer container, JRFillCloneFactory factory) {
        super(container, factory);
        boolean depFlag;
        this.expressionEvaluator = container.expressionEvaluator;
        this.initDeepElements();
        this.filler = container.filler;
        this.legacyElementStretchEnabled = depFlag = this.filler.getFillContext().isLegacyElementStretchEnabled();
    }

    protected void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList<JRFillElement> deepElementsList = new ArrayList<JRFillElement>(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, deepElementsList);
            this.deepElements = new JRFillElement[deepElementsList.size()];
            deepElementsList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] elements, List<JRFillElement> deepElementsList) {
        for (int i = 0; i < elements.length; ++i) {
            JRElement element = elements[i];
            deepElementsList.add((JRFillElement)element);
            if (!(element instanceof JRFillFrame)) continue;
            JRFrame frame = (JRFrame)element;
            JRFillElementContainer.collectDeepElements(frame.getElements(), deepElementsList);
        }
    }

    protected final void _initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> sortedElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            this.topElementInGroup = null;
            this.bottomElementInGroup = null;
            for (JRFillElement element : this.elements) {
                sortedElemsList.add(element);
                if (element.getPositionTypeValue() == PositionTypeEnum.FIX_RELATIVE_TO_BOTTOM) {
                    bandBottomElemsList.add(element);
                }
                if (element.getStretchTypeValue() != StretchTypeEnum.NO_STRETCH) {
                    stretchElemsList.add(element);
                }
                if (element.isRemoveLineWhenBlank()) {
                    removableElemsList.add(element);
                }
                if (element.isPrintWhenDetailOverflows()) {
                    this.hasPrintWhenOverflowElement = true;
                }
                if (this.topElementInGroup == null || element.getY() + element.getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = element;
                }
                if (this.bottomElementInGroup != null && element.getY() + element.getHeight() <= this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight()) continue;
                this.bottomElementInGroup = element;
            }
            Collections.sort(sortedElemsList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            sortedElemsList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
    }

    protected final void initElements() {
        if (this.isLegacyElementStretchEnabled()) {
            this._initElements();
            return;
        }
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> stretchElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> bandBottomElemsList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> removableElemsList = new ArrayList<JRFillElement>();
            JRYComparator yComparator = new JRYComparator();
            this.ySortedElements = Arrays.copyOf(this.elements, this.elements.length);
            Arrays.sort(this.ySortedElements, yComparator);
            this.topElementInGroup = null;
            this.bottomElementInGroup = null;
            for (JRFillElement element : this.ySortedElements) {
                if (element.getPositionTypeValue() == PositionTypeEnum.FIX_RELATIVE_TO_BOTTOM) {
                    bandBottomElemsList.add(element);
                }
                if (element.getStretchTypeValue() != StretchTypeEnum.NO_STRETCH) {
                    stretchElemsList.add(element);
                }
                if (element.isRemoveLineWhenBlank()) {
                    removableElemsList.add(element);
                }
                if (element.isPrintWhenDetailOverflows()) {
                    this.hasPrintWhenOverflowElement = true;
                }
                if (this.topElementInGroup == null || element.getY() + element.getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = element;
                }
                if (this.bottomElementInGroup != null && element.getY() + element.getHeight() <= this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight()) continue;
                this.bottomElementInGroup = element;
            }
            this.stretchElements = new JRFillElement[stretchElemsList.size()];
            stretchElemsList.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[bandBottomElemsList.size()];
            bandBottomElemsList.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[removableElemsList.size()];
            removableElemsList.toArray(this.removableElements);
        }
        this.setDependentElements();
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length - 1; ++i) {
                JRFillElement iElem = this.ySortedElements[i];
                boolean isBreakElem = iElem instanceof JRFillBreak;
                for (int j = i + 1; j < this.ySortedElements.length; ++j) {
                    JRFillElement jElem = this.ySortedElements[j];
                    int left = Math.min(iElem.getX(), jElem.getX());
                    int right = Math.max(iElem.getX() + iElem.getWidth(), jElem.getX() + jElem.getWidth());
                    if ((!isBreakElem || jElem.getPositionTypeValue() != PositionTypeEnum.FIX_RELATIVE_TO_TOP) && jElem.getPositionTypeValue() != PositionTypeEnum.FLOAT || iElem.getY() + iElem.getHeight() > jElem.getY() || iElem.getWidth() + jElem.getWidth() <= right - left) continue;
                    iElem.addDependantElement(jElem);
                }
            }
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                JRFillElement element = (JRFillElement)allElements[i];
                element.setCurrentEvaluation(evaluation);
                element.evaluate(evaluation);
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.reset();
                if (this.isOverflow) continue;
                element.setAlreadyPrinted(false);
            }
        }
    }

    public boolean willOverflow() {
        return this.willOverflowWithElements || this.willOverflowWithWhiteSpace;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow();
        this.firstY = 0;
        this.atLeastOneElementIsToPrint = false;
    }

    protected void _prepareElements(int availableHeight, boolean isOverflowAllowed) throws JRException {
        this.currentOverflowWithElements = false;
        this.currentOverflowWithWhiteSpace = false;
        this.currentOverflowAllowed = isOverflowAllowed;
        int calculatedStretchHeight = this.getContainerHeight();
        this.firstY = this.isOverflow ? this.getActualContainerHeight() : 0;
        this.atLeastOneElementIsToPrint = false;
        boolean isFirstYFound = false;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                this.currentOverflowWithElements = element.prepare(availableHeight + this.getElementFirstY(element), this.isOverflow) || this.currentOverflowWithElements;
                element._moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    isFirstYFound = true;
                }
                this.atLeastOneElementIsToPrint = true;
                int spaceToBottom = this.getContainerHeight() - element.getY() - element.getHeight();
                if (spaceToBottom < 0) {
                    spaceToBottom = 0;
                }
                if (calculatedStretchHeight >= element.getRelativeY() + element.getStretchHeight() + spaceToBottom) continue;
                calculatedStretchHeight = element.getRelativeY() + element.getStretchHeight() + spaceToBottom;
            }
        }
        if (calculatedStretchHeight > availableHeight + this.firstY) {
            this.currentOverflowWithWhiteSpace = true;
        }
        this.stretchHeight = this.currentOverflowWithElements || this.currentOverflowWithWhiteSpace ? availableHeight + this.firstY : calculatedStretchHeight;
        this.willOverflowWithElements = this.currentOverflowWithElements && isOverflowAllowed;
        this.willOverflowWithWhiteSpace = this.currentOverflowWithWhiteSpace && isOverflowAllowed;
    }

    protected void prepareElements(int availableHeight, boolean isOverflowAllowed) throws JRException {
        if (this.isLegacyElementStretchEnabled()) {
            this._prepareElements(availableHeight, isOverflowAllowed);
            return;
        }
        this.currentOverflowWithElements = false;
        this.currentOverflowWithWhiteSpace = false;
        this.currentOverflowAllowed = isOverflowAllowed;
        this.firstY = this.isOverflow ? this.getActualContainerHeight() : 0;
        this.atLeastOneElementIsToPrint = false;
        boolean isFirstYFound = false;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (JRFillElement element : this.ySortedElements) {
                this.currentOverflowWithElements = element.prepare(availableHeight + this.getElementFirstY(element), this.isOverflow) || this.currentOverflowWithElements;
                element.moveDependantElements();
                if (!element.isToPrint()) continue;
                if (this.isOverflow) {
                    if (element.isReprinted()) {
                        this.firstY = 0;
                    } else if (!isFirstYFound) {
                        this.firstY = element.getY();
                    }
                    isFirstYFound = true;
                }
                this.atLeastOneElementIsToPrint = true;
            }
        }
        this.stretchHeight = this.getContainerHeight();
        this.prepareStretchHeight(availableHeight, isOverflowAllowed);
        this.moveBandBottomElements();
        this.removeBlankElements();
        this.stretchElementsToElementGroup();
        this.prepareStretchHeight(availableHeight, isOverflowAllowed);
        this.moveBandBottomElements();
        this.stretchElementsToContainer();
    }

    protected void prepareStretchHeight(int availableHeight, boolean isOverflowAllowed) throws JRException {
        int calculatedStretchHeight = this.calculateStretchHeight();
        if (calculatedStretchHeight > availableHeight + this.firstY) {
            this.currentOverflowWithWhiteSpace = true;
        }
        this.stretchHeight = this.currentOverflowWithElements || this.currentOverflowWithWhiteSpace ? availableHeight + this.firstY : calculatedStretchHeight;
        this.willOverflowWithElements = this.currentOverflowWithElements && isOverflowAllowed;
        this.willOverflowWithWhiteSpace = this.currentOverflowWithWhiteSpace && isOverflowAllowed;
    }

    protected int calculateStretchHeight() throws JRException {
        int calculatedStretchHeight = -1;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            int containerHeight = this.getContainerHeight();
            for (JRFillElement element : this.ySortedElements) {
                if (!element.isToPrint()) continue;
                int spaceToBottom = containerHeight - (element.getY() + element.getHeight()) - element.getCollapsedHeightBelow();
                if (spaceToBottom < 0) {
                    spaceToBottom = 0;
                }
                if (calculatedStretchHeight >= element.getRelativeY() + element.getStretchHeight() + spaceToBottom) continue;
                calculatedStretchHeight = element.getRelativeY() + element.getStretchHeight() + spaceToBottom;
            }
        }
        if (calculatedStretchHeight < 0) {
            calculatedStretchHeight = this.stretchHeight;
        }
        return calculatedStretchHeight;
    }

    public boolean isLegacyElementStretchEnabled() {
        return this.legacyElementStretchEnabled;
    }

    @Override
    public boolean isCurrentOverflow() {
        return this.currentOverflowWithElements || this.currentOverflowWithWhiteSpace;
    }

    @Override
    public boolean isCurrentOverflowAllowed() {
        return this.currentOverflowAllowed;
    }

    private int getElementFirstY(JRFillElement element) {
        int elemFirstY = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (element.getY() >= this.firstY ? this.firstY : element.getY());
        return elemFirstY;
    }

    protected void _setStretchHeight(int stretchHeight) {
        if (stretchHeight > this.stretchHeight) {
            this.stretchHeight = stretchHeight;
        }
    }

    protected void stretchElements() {
        JRFillElement element;
        int i;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (i = 0; i < this.stretchElements.length; ++i) {
                element = this.stretchElements[i];
                element._stretchElement(this.stretchHeight - this.getContainerHeight());
                element._moveDependantElements();
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (i = 0; i < this.ySortedElements.length; ++i) {
                element = this.ySortedElements[i];
                element.stretchHeightFinal();
            }
        }
    }

    protected void setStretchHeight(int stretchHeight) {
        if (this.isLegacyElementStretchEnabled()) {
            this._setStretchHeight(stretchHeight);
            return;
        }
        this.stretchHeight = stretchHeight;
    }

    protected void stretchElementsToElementGroup() {
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            for (int i = 0; i < this.stretchElements.length; ++i) {
                boolean applied;
                JRFillElement element = this.stretchElements[i];
                if (!element.isToPrint() || !(applied = element.stretchElementToElementGroup())) continue;
                element.moveDependantElements();
            }
        }
    }

    protected void stretchElementsToContainer() {
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            int containerStretch = this.stretchHeight - this.getContainerHeight();
            for (int i = 0; i < this.stretchElements.length; ++i) {
                boolean applied;
                JRFillElement element = this.stretchElements[i];
                if (!element.isToPrint() || !(applied = element.stretchElementToContainer(containerStretch))) continue;
                element.moveDependantElements();
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            for (int i = 0; i < this.bandBottomElements.length; ++i) {
                JRFillElement element = this.bandBottomElements[i];
                if (element.isToPrint()) {
                    if (this.currentOverflowWithElements || this.currentOverflowWithWhiteSpace) {
                        this.currentOverflowWithElements = true;
                    }
                    element.setToPrint(!this.currentOverflowWithElements && !this.willOverflowWithWhiteSpace || !this.currentOverflowAllowed);
                }
                if (!element.isToPrint()) continue;
                element.setRelativeY(element.getY() + this.stretchHeight - this.getActualContainerHeight());
            }
        }
    }

    protected void _removeBlankElements() {
        JRFillElement[] remElems = this.removableElements;
        if (remElems != null && remElems.length > 0) {
            JRFillElement[] elems = this.ySortedElements;
            for (int i = 0; i < remElems.length; ++i) {
                JRFillElement jElem;
                int j;
                JRFillElement iElem = remElems[i];
                int blankHeight = iElem.isToPrint() ? iElem.getHeight() - iElem.getStretchHeight() : iElem.getHeight();
                if (blankHeight <= 0 || iElem.getRelativeY() + iElem.getStretchHeight() > this.stretchHeight || iElem.getRelativeY() < this.firstY) continue;
                int blankY = iElem.getRelativeY() + iElem.getHeight() - blankHeight;
                boolean isToRemove = true;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (iElem == jElem || !jElem.isToPrint()) continue;
                    int top = Math.min(blankY, jElem.getRelativeY());
                    int bottom = Math.max(blankY + blankHeight, jElem.getRelativeY() + jElem.getStretchHeight());
                    if (blankHeight + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (j = 0; j < elems.length; ++j) {
                    jElem = elems[j];
                    if (jElem.getRelativeY() < blankY + blankHeight) continue;
                    jElem.setRelativeY(jElem.getRelativeY() - blankHeight);
                }
                this.stretchHeight -= blankHeight;
            }
        }
    }

    protected void removeBlankElements() {
        if (this.isLegacyElementStretchEnabled()) {
            this._removeBlankElements();
            return;
        }
        if (this.removableElements != null && this.removableElements.length > 0) {
            for (JRFillElement remElem : this.removableElements) {
                int blankHeight = remElem.isToPrint() ? remElem.getHeight() - remElem.getStretchHeight() : remElem.getHeight();
                if (blankHeight <= 0 || remElem.getRelativeY() + remElem.getStretchHeight() > this.stretchHeight || remElem.getRelativeY() < this.firstY) continue;
                int blankY = remElem.getRelativeY() + remElem.getHeight() - blankHeight;
                boolean isToRemove = true;
                for (JRFillElement jElem : this.ySortedElements) {
                    if (remElem == jElem || !jElem.isToPrint()) continue;
                    int top = Math.min(blankY, jElem.getRelativeY());
                    int bottom = Math.max(blankY + blankHeight, jElem.getRelativeY() + jElem.getStretchHeight());
                    if (blankHeight + jElem.getStretchHeight() <= bottom - top) continue;
                    isToRemove = false;
                    break;
                }
                if (!isToRemove) continue;
                for (JRFillElement jElem : this.ySortedElements) {
                    if (jElem.getRelativeY() + jElem.getStretchHeight() <= blankY) {
                        jElem.setCollapsedHeightBelow(jElem.getCollapsedHeightBelow() + blankHeight);
                    }
                    if (jElem.getRelativeY() < blankY + blankHeight) continue;
                    jElem.setCollapsedHeightAbove(jElem.getCollapsedHeightAbove() + blankHeight);
                    jElem.setRelativeY(jElem.getRelativeY() - blankHeight);
                }
                this.stretchHeight -= blankHeight;
            }
        }
    }

    public void fillElements(JRPrintElementContainer printContainer) throws JRException {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            for (int i = 0; i < allElements.length; ++i) {
                JRFillElement element = (JRFillElement)allElements[i];
                element.setRelativeY(element.getRelativeY() - this.firstY);
                if (element.getRelativeY() + element.getStretchHeight() > this.stretchHeight - this.firstY) {
                    element.setToPrint(false);
                }
                element.setAlreadyPrinted(element.isToPrint() || element.isAlreadyPrinted());
                if (!element.isToPrint()) continue;
                JRPrintElement printElement = element.fill();
                if (printElement != null) {
                    printContainer.addElement(printElement);
                }
                if (element instanceof JRFillSubreport) {
                    JRFillSubreport subreport = (JRFillSubreport)element;
                    List<JRStyle> styles = subreport.subreportFiller.getJasperPrint().getStylesList();
                    for (int j = 0; j < styles.size(); ++j) {
                        this.filler.addPrintStyle(styles.get(j));
                    }
                    List<JROrigin> origins = subreport.subreportFiller.getJasperPrint().getOriginsList();
                    for (int j = 0; j < origins.size(); ++j) {
                        this.filler.getJasperPrint().addOrigin(origins.get(j));
                    }
                    Collection<JRPrintElement> printElements = subreport.getPrintElements();
                    this.addSubElements(printContainer, element, printElements);
                    subreport.subreportPageFilled();
                }
                if (!(element instanceof JRFillCrosstab)) continue;
                List<? extends JRPrintElement> printElements = ((JRFillCrosstab)element).getPrintElements();
                this.addSubElements(printContainer, element, printElements);
            }
        }
        printContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer printContainer, JRFillElement element, Collection<? extends JRPrintElement> printElements) {
        if (printContainer instanceof JRPrintBand) {
            ((JRPrintBand)printContainer).addOffsetElements(printElements, element.getX(), element.getRelativeY());
        } else if (printElements != null && printElements.size() > 0) {
            for (JRPrintElement jRPrintElement : printElements) {
                jRPrintElement.setX(element.getX() + jRPrintElement.getX());
                jRPrintElement.setY(element.getRelativeY() + jRPrintElement.getY());
                printContainer.addElement(jRPrintElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            for (int i = 0; i < this.ySortedElements.length; ++i) {
                JRFillElement element = this.ySortedElements[i];
                element.rewind();
                element.setAlreadyPrinted(false);
            }
        }
        this.willOverflowWithElements = false;
        this.willOverflowWithWhiteSpace = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getActualContainerHeight();

    protected abstract int getContainerHeight();

    protected void initConditionalStyles() {
        int i;
        this.filler.addDefaultStyleListener(new JRBaseFiller.DefaultStyleListener(){

            @Override
            public void defaultStyleSet(JRStyle style) {
                JRFillElementContainer.this.collectConditionalStyle(style);
            }
        });
        for (i = 0; i < this.deepElements.length; ++i) {
            JRStyle style = this.deepElements[i].initStyle;
            this.collectConditionalStyle(style);
        }
        if (this.deepElements.length > 0) {
            for (i = 0; i < this.deepElements.length; ++i) {
                this.deepElements[i].setConditionalStylesContainer(this);
            }
        }
    }

    protected void collectConditionalStyle(JRStyle style) {
        if (style != null) {
            this.stylesToEvaluate.add(style);
        }
    }

    protected void evaluateConditionalStyles(byte evaluation) throws JRException {
        Iterator<JRStyle> it = this.stylesToEvaluate.iterator();
        while (it.hasNext()) {
            this.evaluateConditionalStyle(it.next(), evaluation);
        }
    }

    protected JRStyle evaluateConditionalStyle(JRStyle initialStyle, byte evaluation) throws JRException {
        JRStyle consolidatedStyle = initialStyle;
        StringBuilder code = new StringBuilder();
        ArrayList<JRStyle> condStylesToApply = new ArrayList<JRStyle>();
        boolean anyTrue = this.buildConsolidatedStyle(initialStyle, evaluation, code, condStylesToApply);
        if (anyTrue) {
            String consolidatedStyleName = initialStyle.getName() + "|" + code.toString();
            consolidatedStyle = this.filler.getJasperPrint().getStylesMap().get(consolidatedStyleName);
            if (consolidatedStyle == null) {
                JRBaseStyle style = new JRBaseStyle(consolidatedStyleName);
                for (int j = condStylesToApply.size() - 1; j >= 0; --j) {
                    StyleUtil.appendStyle(style, (JRStyle)condStylesToApply.get(j));
                }
                style = this.filler.fillContext.deduplicate(style);
                this.filler.addPrintStyle(style);
                consolidatedStyle = style;
            }
        }
        this.evaluatedStyles.put(initialStyle, consolidatedStyle);
        return consolidatedStyle;
    }

    protected boolean buildConsolidatedStyle(JRStyle style, byte evaluation, StringBuilder code, List<JRStyle> condStylesToApply) throws JRException {
        boolean anyTrue = false;
        JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
        if (conditionalStyles != null && conditionalStyles.length > 0) {
            for (int j = 0; j < conditionalStyles.length; ++j) {
                JRConditionalStyle conditionalStyle = conditionalStyles[j];
                Boolean expressionValue = (Boolean)this.expressionEvaluator.evaluate(conditionalStyle.getConditionExpression(), evaluation);
                boolean condition = expressionValue == null ? false : expressionValue;
                code.append(condition ? (char)'1' : '0');
                anyTrue |= condition;
                if (!condition) continue;
                condStylesToApply.add(conditionalStyle);
            }
        }
        condStylesToApply.add(style);
        if (style.getStyle() != null) {
            anyTrue |= this.buildConsolidatedStyle(style.getStyle(), evaluation, code, condStylesToApply);
        }
        return anyTrue;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle parentStyle) {
        return this.evaluatedStyles.get(parentStyle);
    }

    protected final void setElementOriginProvider(JROriginProvider originProvider) {
        if (originProvider != null) {
            for (int i = 0; i < this.deepElements.length; ++i) {
                this.deepElements[i].setOriginProvider(originProvider);
            }
        }
    }
}

