/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.NamedChartCustomizer;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillChart;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;

public abstract class JRAbstractChartCustomizer
implements NamedChartCustomizer {
    protected JRFillChart chart;
    private JRFillChartDataset chartDataset;
    protected JRBaseFiller filler;
    private JRPropertiesUtil propertiesUtil;
    private String name;

    protected JRAbstractChartCustomizer() {
    }

    public void init(JRBaseFiller chartFiller, JRFillChart chart) {
        this.init(chart);
    }

    public void init(JRFillChart chart) {
        this.chart = chart;
        this.chartDataset = (JRFillChartDataset)chart.getDataset();
        this.filler = chart.getFiller();
        this.propertiesUtil = this.filler.getPropertiesUtil();
    }

    protected final Object getParameterValue(String parameterName) {
        return this.getParameterValue(parameterName, false);
    }

    protected final Object getParameterValue(String parameterName, boolean fromInputDataset) {
        return (fromInputDataset ? this.chartDataset.getInputDataset() : this.filler.getMainDataset()).getParameterValue(parameterName);
    }

    protected final Object getVariableValue(String variableName) {
        return this.getVariableValue(variableName, false);
    }

    protected final Object getVariableValue(String variableName, boolean fromInputDataset) {
        return (fromInputDataset ? this.chartDataset.getInputDataset() : this.filler.getMainDataset()).getVariableValue(variableName);
    }

    protected final Object getFieldValue(String fieldName) {
        return this.getFieldValue(fieldName, false);
    }

    protected final Object getFieldValue(String fieldName, boolean fromInputDataset) {
        return (fromInputDataset ? this.chartDataset.getInputDataset() : this.filler.getMainDataset()).getFieldValue(fieldName);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public final String getCustomizerPropertyName(String propertySuffix) {
        return "net.sf.jasperreports.customizer." + (this.name == null ? "" : this.name) + "." + propertySuffix;
    }

    public final Boolean getBooleanProperty(String propertySuffix) {
        return this.propertiesUtil.getBooleanProperty(this.chart, this.getCustomizerPropertyName(propertySuffix));
    }

    public final String getProperty(String propertySuffix) {
        return this.propertiesUtil.getProperty(this.chart, this.getCustomizerPropertyName(propertySuffix));
    }

    public final Integer getIntegerProperty(String propertySuffix) {
        return this.propertiesUtil.getIntegerProperty(this.chart, this.getCustomizerPropertyName(propertySuffix));
    }

    public final Float getFloatProperty(String propertySuffix) {
        return this.propertiesUtil.getFloatProperty(this.chart, this.getCustomizerPropertyName(propertySuffix));
    }

    public final Double getDoubleProperty(String propertySuffix) {
        return this.propertiesUtil.getDoubleProperty(this.chart, this.getCustomizerPropertyName(propertySuffix));
    }
}

