/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.list.BaseFillList;
import net.sf.jasperreports.components.list.FillListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.ListContents;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HorizontalFillList
extends BaseFillList {
    private static final Log log = LogFactory.getLog(HorizontalFillList.class);
    public static final String EXCEPTION_MESSAGE_KEY_ROW_OVERFLOW = "fill.horizontal.list.row.overflow";
    private final int contentsWidth;
    private final boolean ignoreWidth;
    private final List<FillListContents> contentsList;
    private int overflowStartPage;
    private int overflowColumnIndex;

    public HorizontalFillList(ListComponent component, JRFillObjectFactory factory) throws JRException {
        super(component, factory);
        ListContents listContents = component.getContents();
        this.contentsWidth = listContents.getWidth();
        Boolean listIgnoreWidth = component.getIgnoreWidth();
        this.ignoreWidth = listIgnoreWidth != null && listIgnoreWidth != false;
        JRFillObjectFactory datasetFactory = new JRFillObjectFactory(factory, this.createDatasetExpressionEvaluator());
        FillListContents fillContents = new FillListContents(listContents, datasetFactory);
        this.contentsList = new ArrayList<FillListContents>();
        this.contentsList.add(fillContents);
    }

    protected HorizontalFillList(HorizontalFillList list, JRFillCloneFactory factory) {
        super(list, factory);
        this.contentsWidth = list.contentsWidth;
        this.ignoreWidth = list.ignoreWidth;
        FillListContents listContents = list.contentsList.get(0);
        FillListContents contentsClone = new FillListContents(listContents, factory);
        this.contentsList = new ArrayList<FillListContents>();
        this.contentsList.add(contentsClone);
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        this.createPrintFrame();
        try {
            boolean hadData = false;
            if (this.filling) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Refilling list row after overflow");
                }
                hadData = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starting list rendering");
                }
                if (this.fillStarted) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"List reprinted, rewinding data source");
                    }
                    this.datasetRun.rewind();
                }
                this.datasetRun.start();
                this.fillStarted = true;
                this.overflowStartPage = 0;
            }
            boolean overflow = false;
            int columnIndex = 0;
            while (!overflow) {
                boolean refillOverflowed;
                int contentsAvailableHeight = availableHeight - this.printFrame.getHeight();
                if (contentsAvailableHeight < this.contentsHeight) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Not enough space left for a list row, overflowing");
                    }
                    overflow = true;
                    continue;
                }
                boolean bl = refillOverflowed = columnIndex < this.overflowColumnIndex;
                if (!refillOverflowed && !this.datasetRun.next()) break;
                FillListContents listContents = this.getContents(columnIndex);
                if (refillOverflowed) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Refilling overflowed cell at column " + columnIndex));
                    }
                    listContents.rewind();
                } else {
                    hadData = true;
                    this.overflowStartPage = 0;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Filling new cell at column " + columnIndex));
                    }
                    listContents.evaluateContents();
                }
                listContents.prepare(contentsAvailableHeight);
                overflow = listContents.willOverflow();
                if (overflow || this.ignoreWidth || this.contentsWidth * (++columnIndex + 1) <= this.fillContext.getComponentElement().getWidth()) continue;
                this.fillRow(columnIndex);
                columnIndex = 0;
                this.overflowColumnIndex = 0;
            }
            if (overflow) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("List has overflowed at column " + (columnIndex - 1)));
                }
                int pageCount = this.fillContext.getFiller().getCurrentPageCount();
                if (this.overflowStartPage == 0) {
                    this.overflowStartPage = pageCount;
                } else if (pageCount >= this.overflowStartPage + 2) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_ROW_OVERFLOW, (Object[])null);
                }
                this.filling = true;
                this.overflowColumnIndex = columnIndex;
                return FillPrepareResult.printStretch(availableHeight, overflow);
            }
            if (columnIndex > 0) {
                this.fillRow(columnIndex);
                this.overflowColumnIndex = 0;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"List has completed rendering");
            }
            this.filling = false;
            this.datasetRun.end();
            this.datasetRun.copyReturnValues();
            if (!hadData) {
                return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
            }
            return FillPrepareResult.printStretch(this.printFrame.getHeight(), false);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void fillRow(int columnCount) throws JRException {
        int rightPadding;
        JRStyle style;
        int leftPadding;
        int requiredWidth;
        FillListContents contents;
        int idx;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completed a row with " + columnCount + " columns"));
        }
        BaseFillList.AppendingPrintElementContainer printContainer = new BaseFillList.AppendingPrintElementContainer(this.printFrame);
        int rowHeight = 0;
        for (idx = 0; idx < columnCount; ++idx) {
            contents = this.contentsList.get(idx);
            int cellHeight = contents.getStretchHeight();
            if (cellHeight <= rowHeight) continue;
            rowHeight = cellHeight;
        }
        for (idx = 0; idx < columnCount; ++idx) {
            contents = this.contentsList.get(idx);
            contents.stretchTo(rowHeight);
            contents.finalizeElementPositions();
            printContainer.setXOffset(idx * this.contentsWidth);
            contents.fillElements(printContainer);
        }
        if (this.ignoreWidth && (requiredWidth = columnCount * this.contentsWidth + (leftPadding = (style = this.printFrame.getStyle()) == null ? 0 : style.getLineBox().getLeftPadding()) + (rightPadding = style == null ? 0 : style.getLineBox().getRightPadding())) > this.printFrame.getWidth()) {
            this.printFrame.setWidth(requiredWidth);
        }
    }

    protected FillListContents getContents(int columnIndex) {
        if (columnIndex > 0 && columnIndex >= this.contentsList.size()) {
            FillListContents template = this.contentsList.get(0);
            for (int idx = this.contentsList.size(); idx <= columnIndex; ++idx) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cloning list fill contents for column " + idx));
                }
                FillListContents clone = template.createClone();
                this.contentsList.add(clone);
            }
        }
        return this.contentsList.get(columnIndex);
    }

    @Override
    public void rewind() {
        super.rewind();
        this.overflowStartPage = 0;
        this.overflowColumnIndex = 0;
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new HorizontalFillList(this, factory);
    }
}

