/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;

public class NodeHelper {
    public static <T> T findParentOfType(Node node, Class<T> type) {
        if (node == null) {
            return null;
        }
        Parent parent = node.getParent();
        if (parent == null) {
            return null;
        }
        if (type.isAssignableFrom(parent.getClass())) {
            return (T)parent;
        }
        return NodeHelper.findParentOfType((Node)parent, type);
    }

    public static <T> List<T> findChildrenOfType(Pane parent, Class<T> type) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Node node : parent.getChildren()) {
            if (type.isAssignableFrom(node.getClass())) {
                elements.add(node);
                continue;
            }
            if (!(node instanceof Pane)) continue;
            elements.addAll(NodeHelper.findChildrenOfType((Pane)node, type));
        }
        return Collections.unmodifiableList(elements);
    }

    public static void addPseudoClass(Node node, String className) {
        PseudoClass pseudoClass = PseudoClass.getPseudoClass((String)className);
        node.pseudoClassStateChanged(pseudoClass, true);
    }
}

