/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.table;

import java.lang.reflect.Field;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class LeanPropertyValueFactory<S, T>
implements Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> {
    private final String property;
    private Field field;

    public LeanPropertyValueFactory(@NamedArg(value="property") String property) {
        this.property = property;
    }

    public ObservableValue<T> call(TableColumn.CellDataFeatures<S, T> param) {
        if (param != null && param.getValue() != null) {
            if (this.field == null) {
                try {
                    this.field = param.getValue().getClass().getDeclaredField(this.property + "Property");
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(String.format("No field named %s in %s", this.property, param.getValue().getClass()));
                }
            }
            try {
                return (ObservableValue)this.field.get(param.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Unable to extract value from field %s", this.field.getName()), e);
            }
        }
        return null;
    }
}

