/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control.skin;

import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;
import tornadofx.control.ListItem;
import tornadofx.control.ListMenu;

public class ListItemSkin
extends SkinBase<ListItem> {
    private final Text text = new Text();

    public ListItemSkin(ListItem control) {
        super((Control)control);
        this.text.textProperty().bind((ObservableValue)control.getTextProperty());
        this.getChildren().add((Object)this.text);
        if (((ListItem)this.getSkinnable()).getGraphic() != null) {
            this.getChildren().add((Object)((ListItem)this.getSkinnable()).getGraphic());
        }
        control.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            control.requestFocus();
            ListMenu menu = (ListMenu)control.getParent();
            menu.setActive(control);
        });
    }

    private double acc(Function<Node, Double> fn) {
        double val = fn.apply((Node)this.text);
        if (((ListItem)this.getSkinnable()).getGraphic() != null) {
            val += fn.apply(((ListItem)this.getSkinnable()).getGraphic()).doubleValue();
        }
        return val;
    }

    private double biggest(Function<Node, Double> fn) {
        double gval;
        double val = fn.apply((Node)this.text);
        if (((ListItem)this.getSkinnable()).getGraphic() != null && (gval = fn.apply(((ListItem)this.getSkinnable()).getGraphic()).doubleValue()) > val) {
            return gval;
        }
        return val;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.iconPosition().isHorizontal()) {
            return this.biggest(n -> n.minWidth(height));
        }
        return this.acc(n -> n.minWidth(height));
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.iconPosition().isHorizontal()) {
            return this.acc(n -> n.minHeight(width));
        }
        return this.biggest(n -> n.minHeight(width));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double w = this.text.prefWidth(height);
        if (((ListItem)this.getSkinnable()).getGraphic() != null && this.iconPosition().isVertical()) {
            w += Math.max(((ListItem)this.getSkinnable()).getGraphic().prefWidth(-1.0), this.graphicFixedSize());
        }
        return w + leftInset + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double h = this.text.prefHeight(width);
        if (((ListItem)this.getSkinnable()).getGraphic() != null && this.iconPosition().isHorizontal()) {
            h += Math.max(((ListItem)this.getSkinnable()).getGraphic().prefHeight(-1.0), this.graphicFixedSize());
        }
        return h + topInset + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    private Side iconPosition() {
        ListMenu menu = (ListMenu)((ListItem)this.getSkinnable()).getParent();
        return menu.getIconPosition();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        Node graphic = ((ListItem)this.getSkinnable()).getGraphic();
        switch (this.iconPosition()) {
            case TOP: {
                double centeredX;
                if (graphic != null) {
                    centeredX = x + w / 2.0 - graphic.getLayoutBounds().getWidth() / 2.0;
                    graphic.relocate(centeredX, y);
                    y += Math.max(graphic.getLayoutBounds().getHeight(), this.graphicFixedSize());
                }
                centeredX = x + w / 2.0 - this.text.prefWidth(-1.0) / 2.0;
                this.text.resizeRelocate(centeredX, y, this.text.prefWidth(-1.0), this.text.prefHeight(-1.0));
                break;
            }
            case BOTTOM: {
                double centeredX = x + w / 2.0 - this.text.prefWidth(-1.0) / 2.0;
                this.text.resizeRelocate(centeredX, y, this.text.prefWidth(-1.0), this.text.prefHeight(-1.0));
                if (graphic == null) break;
                y += this.text.prefHeight(-1.0);
                double fixedSize = this.graphicFixedSize();
                if (fixedSize > graphic.getLayoutBounds().getHeight()) {
                    y += fixedSize - graphic.getLayoutBounds().getHeight();
                }
                centeredX = x + w / 2.0 - graphic.getLayoutBounds().getWidth() / 2.0;
                graphic.relocate(centeredX, y);
                break;
            }
            case LEFT: {
                double centeredY;
                if (graphic != null) {
                    centeredY = y + h / 2.0 - graphic.getLayoutBounds().getHeight() / 2.0;
                    graphic.relocate(x, centeredY);
                    x += Math.max(graphic.getLayoutBounds().getWidth(), this.graphicFixedSize());
                }
                centeredY = y + h / 2.0 - this.text.prefHeight(-1.0) / 2.0;
                this.text.resizeRelocate(x, centeredY, this.text.prefWidth(-1.0), this.text.prefHeight(-1.0));
                break;
            }
            case RIGHT: {
                double centeredY;
                if (graphic != null) {
                    centeredY = y + h / 2.0 - graphic.getLayoutBounds().getHeight() / 2.0;
                    double graphicWidth = Math.max(graphic.getLayoutBounds().getWidth(), this.graphicFixedSize());
                    graphic.resizeRelocate(w, centeredY, graphicWidth, graphic.prefHeight(-1.0));
                }
                centeredY = y + h / 2.0 - this.text.prefHeight(-1.0) / 2.0;
                this.text.resizeRelocate(x, centeredY, this.text.prefWidth(-1.0), this.text.prefHeight(-1.0));
                break;
            }
        }
    }

    private double graphicFixedSize() {
        ListMenu menu = (ListMenu)((ListItem)this.getSkinnable()).getParent();
        return ((Number)menu.graphicFixedSizeProperty().getValue()).doubleValue();
    }
}

