/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import tornadofx.control.ListItem;
import tornadofx.control.skin.ListMenuSkin;

@DefaultProperty(value="children")
public class ListMenu
extends Control {
    private static final PseudoClass ACTIVE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"active");
    private static final StyleablePropertyFactory<ListMenu> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private StyleableProperty<Number> graphicFixedSize = FACTORY.createStyleableNumberProperty((Styleable)this, "graphicFixedSize", "-fx-graphic-fixed-size", ListMenu::graphicFixedSizeProperty);
    private Property<ListItem> active = new SimpleObjectProperty<ListItem>((Object)this, "active"){

        public void set(ListItem item) {
            ListItem previouslyActive = (ListItem)((Object)this.get());
            if (item == previouslyActive) {
                return;
            }
            if (previouslyActive != null) {
                previouslyActive.pseudoClassStateChanged(ACTIVE_PSEUDOCLASS_STATE, false);
            }
            item.pseudoClassStateChanged(ACTIVE_PSEUDOCLASS_STATE, true);
            super.set((Object)item);
        }
    };
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty<Orientation>(Orientation.VERTICAL){

        protected void invalidated() {
            ListMenu.this.setNeedsLayout(true);
            ListMenu.this.requestLayout();
        }
    };
    private final ObjectProperty<Side> iconPosition = new SimpleObjectProperty<Side>(Side.LEFT){

        protected void invalidated() {
            ListMenu.this.getChildren().forEach(child -> {
                if (child instanceof ListItem) {
                    ((ListItem)((Object)child)).needsLayout();
                }
            });
        }
    };

    public final StyleableProperty<Number> graphicFixedSizeProperty() {
        return this.graphicFixedSize;
    }

    public void setActive(ListItem item) {
        this.active.setValue((Object)item);
    }

    public ListItem getActive() {
        return (ListItem)((Object)this.active.getValue());
    }

    public Property<ListItem> activeProperty() {
        return this.active;
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public Side getIconPosition() {
        return (Side)this.iconPosition.get();
    }

    public ObjectProperty<Side> iconPositionProperty() {
        return this.iconPosition;
    }

    public void setIconPosition(Side iconPosition) {
        this.iconPosition.set((Object)iconPosition);
    }

    public ListMenu() {
        this.getStyleClass().add((Object)"list-menu");
        this.setFocusTraversable(true);
    }

    public ListMenu(ListItem ... items) {
        this();
        if (items != null) {
            this.getChildren().addAll((Object[])items);
        }
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    protected Skin<?> createDefaultSkin() {
        return new ListMenuSkin(this);
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getUserAgentStylesheet() {
        return ListMenu.class.getResource("listmenu.css").toExternalForm();
    }
}

