/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import tornadofx.control.ListMenu;
import tornadofx.control.skin.ListItemSkin;

public class ListItem
extends Control {
    private Node graphic;
    private final StringProperty textProperty = new SimpleStringProperty((Object)this, "text");

    public Node getGraphic() {
        return this.graphic;
    }

    public void setGraphic(Node graphic) {
        this.graphic = graphic;
    }

    public String getText() {
        return (String)this.textProperty.get();
    }

    public StringProperty getTextProperty() {
        return this.textProperty;
    }

    public void setText(String text) {
        this.textProperty.set((Object)text);
    }

    public ListItem() {
        this.getStyleClass().add((Object)"list-item");
        this.setFocusTraversable(true);
    }

    public ListItem(String text) {
        this();
        this.setText(text);
    }

    public ListItem(String text, Node graphic) {
        this(text);
        this.setGraphic(graphic);
    }

    protected Skin<?> createDefaultSkin() {
        return new ListItemSkin(this);
    }

    public void needsLayout() {
        this.setNeedsLayout(true);
        this.requestLayout();
    }

    public void setActive(boolean active) {
        Platform.runLater(() -> {
            ListMenu menu = this.getMenu();
            if (active) {
                menu.setActive(this);
            } else if (menu.getActive() == this) {
                menu.setActive(null);
            }
        });
    }

    public boolean getActive() {
        return this.getMenu().getActive() == this;
    }

    private ListMenu getMenu() {
        return (ListMenu)this.getParent();
    }
}

