/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;

public class DateTimePicker
extends DatePicker {
    public static final String DefaultFormat = "yyyy-MM-dd HH:mm";
    private DateTimeFormatter formatter;
    private ObjectProperty<LocalDateTime> dateTimeValue = new SimpleObjectProperty((Object)LocalDateTime.now());
    private ObjectProperty<String> format = new SimpleObjectProperty<String>(){

        public void set(String newValue) {
            super.set((Object)newValue);
            DateTimePicker.this.formatter = DateTimeFormatter.ofPattern(newValue);
        }
    };

    public void alignColumnCountWithFormat() {
        this.getEditor().setPrefColumnCount(this.getFormat().length());
    }

    public DateTimePicker() {
        this.getStyleClass().add((Object)"datetime-picker");
        this.setFormat(DefaultFormat);
        this.setConverter(new InternalConverter());
        this.alignColumnCountWithFormat();
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.dateTimeValue.set(null);
            } else if (this.dateTimeValue.get() == null) {
                this.dateTimeValue.set((Object)LocalDateTime.of(newValue, LocalTime.now()));
            } else {
                LocalTime time = ((LocalDateTime)this.dateTimeValue.get()).toLocalTime();
                this.dateTimeValue.set((Object)LocalDateTime.of(newValue, time));
            }
        });
        this.dateTimeValue.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                LocalDate dateValue = newValue.toLocalDate();
                boolean forceUpdate = dateValue.equals(this.valueProperty().get());
                this.setValue(dateValue);
                if (forceUpdate) {
                    this.setConverter(new InternalConverter());
                }
            } else {
                this.setValue(null);
            }
        });
        this.getEditor().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.simulateEnterPressed();
            }
        });
    }

    private void simulateEnterPressed() {
        this.getEditor().commitValue();
    }

    public LocalDateTime getDateTimeValue() {
        return (LocalDateTime)this.dateTimeValue.get();
    }

    public void setDateTimeValue(LocalDateTime dateTimeValue) {
        this.dateTimeValue.set((Object)dateTimeValue);
    }

    public ObjectProperty<LocalDateTime> dateTimeValueProperty() {
        return this.dateTimeValue;
    }

    public String getFormat() {
        return (String)this.format.get();
    }

    public ObjectProperty<String> formatProperty() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format.set((Object)format);
        this.alignColumnCountWithFormat();
    }

    class InternalConverter
    extends StringConverter<LocalDate> {
        InternalConverter() {
        }

        public String toString(LocalDate object) {
            LocalDateTime value = DateTimePicker.this.getDateTimeValue();
            return value != null ? value.format(DateTimePicker.this.formatter) : "";
        }

        public LocalDate fromString(String value) {
            if (value == null || value.isEmpty()) {
                DateTimePicker.this.dateTimeValue.set(null);
                return null;
            }
            DateTimePicker.this.dateTimeValue.set((Object)LocalDateTime.parse(value, DateTimePicker.this.formatter));
            return ((LocalDateTime)DateTimePicker.this.dateTimeValue.get()).toLocalDate();
        }
    }
}

