/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.time.LocalDate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class DatePickerTableCell<S>
extends TableCell<S, LocalDate> {
    private ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty((Object)this, "converter");
    private DatePicker datePicker;

    public DatePickerTableCell(StringConverter<LocalDate> converter) {
        this.setConverter(converter);
        this.getStyleClass().add((Object)"datepicker-table-cell");
    }

    public static <S> Callback<TableColumn<S, LocalDate>, TableCell<S, LocalDate>> forTableColumn() {
        return column -> new DatePickerTableCell(new DefaultLocalDateConverter());
    }

    public static <S> Callback<TableColumn<S, LocalDate>, TableCell<S, LocalDate>> forTableColumn(StringConverter<LocalDate> converter) {
        return column -> new DatePickerTableCell(converter);
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.datePicker == null) {
                this.createDatePicker();
            }
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
            this.datePicker.requestFocus();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getItemText());
        this.setGraphic(null);
    }

    private String getItemText() {
        return this.getConverter().toString(this.getItem());
    }

    private void createDatePicker() {
        this.datePicker = new DatePicker((LocalDate)this.getItem());
        this.datePicker.converterProperty().bind(this.converterProperty());
        this.datePicker.setOnAction(event -> {
            this.commitEdit(this.datePicker.getValue());
            event.consume();
        });
        this.datePicker.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
    }

    protected void updateItem(LocalDate item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.datePicker.setValue(this.getItem());
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        } else {
            this.setText(this.getItemText());
            this.setGraphic(null);
        }
    }

    public StringConverter<LocalDate> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    public void setConverter(StringConverter<LocalDate> converter) {
        this.converter.set(converter);
    }

    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(DatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public static class DefaultLocalDateConverter
    extends StringConverter<LocalDate> {
        public String toString(LocalDate date) {
            return date != null ? date.toString() : "";
        }

        public LocalDate fromString(String string) {
            return string == null || string.isEmpty() ? null : LocalDate.parse(string);
        }
    }
}

