/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.property;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DirtyState
extends ReadOnlyBooleanWrapper {
    private final ObservableList<Property> properties = FXCollections.observableArrayList();
    private final ObservableList<Property> dirtyProperties = FXCollections.observableArrayList();
    private final ObservableList<Property> unmodifiableDirtyProperties = FXCollections.unmodifiableObservableList(this.dirtyProperties);
    private final Map<Property, Object> initialValues = new HashMap<Property, Object>();
    private DirtyListener dirtyListener = new DirtyListener();

    public DirtyState(Object bean) {
        this(bean, true);
    }

    public DirtyState(Object bean, boolean addDeclaredProperties) {
        super(bean, "dirty", false);
        this.monitorChanges();
        if (addDeclaredProperties) {
            this.addDeclaredProperties();
        }
    }

    public DirtyState(Object bean, List<Property> properties) {
        super(bean, "dirty", false);
        this.monitorChanges();
        this.getProperties().addAll(properties);
    }

    private void addDeclaredProperties() {
        Object bean = this.getBean();
        if (bean == null) {
            return;
        }
        for (Method method : bean.getClass().getDeclaredMethods()) {
            if (!method.getName().endsWith("Property") || !Property.class.isAssignableFrom(method.getReturnType()) || DirtyState.class.isAssignableFrom(method.getReturnType())) continue;
            try {
                Property property = (Property)method.invoke(bean, new Object[0]);
                if (property == null) continue;
                this.properties.add((Object)property);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void monitorChanges() {
        this.properties.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(p -> p.addListener((ChangeListener)this.dirtyListener));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(p -> p.removeListener((ChangeListener)this.dirtyListener));
            }
        });
    }

    public void reset() {
        this.dirtyProperties.clear();
        this.initialValues.clear();
        this.setValue(false);
    }

    public void undo() {
        this.initialValues.forEach(WritableValue::setValue);
        this.setValue(false);
    }

    public Boolean isDirty() {
        return this.getValue();
    }

    public ObservableList<Property> getProperties() {
        return this.properties;
    }

    public ObservableList<Property> getUnmodifiableDirtyProperties() {
        return this.unmodifiableDirtyProperties;
    }

    private class DirtyListener
    implements ChangeListener {
        private DirtyListener() {
        }

        public void changed(ObservableValue property, Object oldValue, Object newValue) {
            if (DirtyState.this.dirtyProperties.contains((Object)property)) {
                if (Objects.equals(DirtyState.this.initialValues.get(property), newValue)) {
                    DirtyState.this.dirtyProperties.remove((Object)property);
                }
                if (DirtyState.this.dirtyProperties.isEmpty() && DirtyState.this.isDirty().booleanValue()) {
                    DirtyState.this.setValue(false);
                }
            } else {
                DirtyState.this.initialValues.put((Property)property, oldValue);
                DirtyState.this.dirtyProperties.add((Object)((Property)property));
                if (!DirtyState.this.isDirty().booleanValue()) {
                    DirtyState.this.setValue(true);
                }
            }
        }
    }
}

