/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.converter;

import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.StringConverter;

public class UnitConverter
extends StringConverter<Long> {
    private static final String units = "kMGTPE";
    private StringProperty separatorProperty = new SimpleStringProperty("");
    private BooleanProperty binaryProperty = new SimpleBooleanProperty((Object)this, "binary", false);
    private static final Pattern ValueWithUnit = Pattern.compile("(\\d+)\\s*([kmgtpe]?)$");

    public String toString(Long value) {
        int unitIndex;
        long base = this.getBase();
        for (unitIndex = 0; unitIndex < units.length(); ++unitIndex) {
            if (value < base || value % base != 0L) {
                return this.out(value, unitIndex);
            }
            value = value / base;
        }
        return this.out(value, unitIndex);
    }

    private String out(long value, int unitIndex) {
        return "" + value + (unitIndex == 0 ? "" : this.getSeparator() + units.charAt(unitIndex - 1));
    }

    public Long fromString(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Matcher matcher = ValueWithUnit.matcher(string.toLowerCase());
        if (!matcher.matches()) {
            throw new UnknownFormatConversionException(String.format("Invalid format %s", string));
        }
        Long value = Long.valueOf(matcher.group(1));
        String unit = matcher.group(2);
        if (unit.isEmpty()) {
            return value;
        }
        int index = units.toLowerCase().indexOf(unit.toLowerCase());
        return value * (long)Math.pow(this.getBase(), (double)index + 1.0);
    }

    private long getBase() {
        return this.getBinary() ? 1024L : 1000L;
    }

    public boolean getBinary() {
        return this.binaryProperty.get();
    }

    public BooleanProperty binaryProperty() {
        return this.binaryProperty;
    }

    public void setBinary(boolean binary) {
        this.binaryProperty.set(binary);
    }

    public String getSeparator() {
        return (String)this.separatorProperty.get();
    }

    public StringProperty separatorProperty() {
        return this.separatorProperty;
    }

    public void setSeparator(String separator) {
        this.separatorProperty.set((Object)separator);
    }
}

