/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control.skin;

import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import tornadofx.control.MultiSelect;

public class MultiSelectSkin<E>
extends SkinBase<MultiSelect<E>> {
    public MultiSelectSkin(MultiSelect<E> control) {
        super(control);
    }

    private double getPrefRowHeight() {
        double editorHeight = ((MultiSelect)this.getSkinnable()).getEditor().prefHeight(-1.0);
        if (this.getChildren().isEmpty()) {
            return editorHeight;
        }
        return Math.max(editorHeight, ((Node)this.getChildren().get(0)).prefHeight(-1.0));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MultiSelect control = (MultiSelect)this.getSkinnable();
        double hgap = control.getHgap().doubleValue();
        double vgap = control.getVgap().doubleValue();
        double prefRowHeight = this.getPrefRowHeight();
        int childCount = this.getChildren().size();
        int rows = height <= 0.0 ? 1 : (int)Math.max(1.0, Math.floor((prefRowHeight + vgap) / height));
        int perRow = (int)Math.ceil(childCount / rows);
        double widestRow = 0.0;
        int childPos = 0;
        for (int rowCount = 0; rowCount < rows; ++rowCount) {
            double rowWidth = 0.0;
            for (double childPosInRow = 0.0; childPosInRow < (double)perRow && childPos < childCount; ++childPos, childPosInRow += 1.0) {
                Node child = (Node)this.getChildren().get(childPos);
                rowWidth += child.prefWidth(prefRowHeight) + hgap;
            }
            if (!(rowWidth > widestRow)) continue;
            widestRow = rowWidth;
        }
        return widestRow + leftInset + rightInset - hgap;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight;
        MultiSelect control = (MultiSelect)this.getSkinnable();
        double usedLineWidth = 0.0;
        double hgap = control.getHgap().doubleValue();
        double vgap = control.getVgap().doubleValue();
        double y = prefHeight = this.getPrefRowHeight();
        if (width == -1.0 && control.getWidth() > 0.0) {
            width = control.getWidth();
        }
        for (Node node : this.getChildren()) {
            double prefWidth = node.prefWidth(prefHeight);
            if (width > 0.0 && usedLineWidth + prefWidth > width && usedLineWidth > 0.0) {
                usedLineWidth = 0.0;
                y += prefHeight + vgap;
            }
            usedLineWidth += prefWidth + hgap;
        }
        return y;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double usedLineWidth = 0.0;
        double hgap = ((MultiSelect)this.getSkinnable()).getHgap().doubleValue();
        double vgap = ((MultiSelect)this.getSkinnable()).getVgap().doubleValue();
        double prefHeight = this.getPrefRowHeight();
        for (Node node : this.getChildren()) {
            double prefWidth = node.prefWidth(prefHeight);
            if (usedLineWidth + prefWidth > contentWidth && usedLineWidth > 0.0) {
                usedLineWidth = 0.0;
                contentY += prefHeight + vgap;
            }
            double x = usedLineWidth + contentX;
            node.resizeRelocate(x, contentY, prefWidth, prefHeight);
            usedLineWidth += prefWidth + hgap;
        }
    }
}

