/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import tornadofx.control.skin.ExpandableTableRowSkin;

public final class TableRowExpanderColumn<S>
extends TableColumn<S, Boolean> {
    private static final String STYLE_CLASS = "expander-column";
    private static final String EXPANDER_BUTTON_STYLE_CLASS = "expander-button";
    private final Map<S, Node> expandedNodeCache = new HashMap<S, Node>();
    private final Map<S, SimpleBooleanProperty> expansionState = new HashMap<S, SimpleBooleanProperty>();
    private Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback;

    public SimpleBooleanProperty getExpandedProperty(S item) {
        SimpleBooleanProperty value = this.expansionState.get(item);
        if (value == null) {
            value = new SimpleBooleanProperty(item, "expanded", false){

                protected void invalidated() {
                    TableRowExpanderColumn.this.getTableView().refresh();
                    if (!this.getValue().booleanValue()) {
                        TableRowExpanderColumn.this.expandedNodeCache.remove(this.getBean());
                    }
                }
            };
            this.expansionState.put(item, value);
        }
        return value;
    }

    public Node getOrCreateExpandedNode(TableRow<S> tableRow) {
        int index = tableRow.getIndex();
        if (index > -1 && index < this.getTableView().getItems().size()) {
            Object item = this.getTableView().getItems().get(index);
            Node node = this.expandedNodeCache.get(item);
            if (node == null) {
                node = (Node)this.expandedNodeCallback.call(new TableRowDataFeatures<Object>(tableRow, this, item));
                this.expandedNodeCache.put(item, node);
            }
            return node;
        }
        return null;
    }

    public Node getExpandedNode(S item) {
        return this.expandedNodeCache.get(item);
    }

    public TableRowExpanderColumn(TableView<S> tableView, Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback) {
        this(expandedNodeCallback);
        tableView.getColumns().add(this);
    }

    public TableRowExpanderColumn(Callback<TableRowDataFeatures<S>, Node> expandedNodeCallback) {
        this.expandedNodeCallback = expandedNodeCallback;
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.setCellValueFactory(param -> this.getExpandedProperty(param.getValue()));
        this.setCellFactory(param -> new ToggleCell());
        this.installRowFactoryOnTableViewAssignment();
    }

    private void installRowFactoryOnTableViewAssignment() {
        this.tableViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.getTableView().setRowFactory(param -> new TableRow<S>(){

                    protected Skin<?> createDefaultSkin() {
                        return new ExpandableTableRowSkin(this, TableRowExpanderColumn.this);
                    }
                });
            }
        });
    }

    public void toggleExpanded(int index) {
        SimpleBooleanProperty expanded;
        expanded.setValue(Boolean.valueOf((expanded = (SimpleBooleanProperty)this.getCellObservableValue(index)).getValue() == false));
    }

    public static class TableRowDataFeatures<S> {
        private TableRow<S> tableRow;
        private TableRowExpanderColumn<S> tableColumn;
        private SimpleBooleanProperty expandedProperty;
        private S value;

        public TableRowDataFeatures(TableRow<S> tableRow, TableRowExpanderColumn<S> tableColumn, S value) {
            this.tableRow = tableRow;
            this.tableColumn = tableColumn;
            this.expandedProperty = (SimpleBooleanProperty)tableColumn.getCellObservableValue(tableRow.getIndex());
            this.value = value;
        }

        public TableRow<S> getTableRow() {
            return this.tableRow;
        }

        public TableRowExpanderColumn<S> getTableColumn() {
            return this.tableColumn;
        }

        public SimpleBooleanProperty expandedProperty() {
            return this.expandedProperty;
        }

        public void toggleExpanded() {
            SimpleBooleanProperty expanded;
            expanded.setValue(Boolean.valueOf((expanded = this.expandedProperty()).getValue() == false));
        }

        public Boolean isExpanded() {
            return this.expandedProperty().getValue();
        }

        public void setExpanded(Boolean expanded) {
            this.expandedProperty().setValue(expanded);
        }

        public S getValue() {
            return this.value;
        }
    }

    private final class ToggleCell
    extends TableCell<S, Boolean> {
        private Button button = new Button();

        public ToggleCell() {
            this.button.setFocusTraversable(false);
            this.button.getStyleClass().add((Object)TableRowExpanderColumn.EXPANDER_BUTTON_STYLE_CLASS);
            this.button.setPrefSize(16.0, 16.0);
            this.button.setPadding(new Insets(0.0));
            this.button.setOnAction(event -> TableRowExpanderColumn.this.toggleExpanded(this.getIndex()));
        }

        protected void updateItem(Boolean expanded, boolean empty) {
            super.updateItem((Object)expanded, empty);
            if (expanded == null || empty) {
                this.setGraphic(null);
            } else {
                this.button.setText(expanded != false ? "-" : "+");
                this.setGraphic((Node)this.button);
            }
        }
    }
}

