/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import java.util.List;
import java.util.function.BiFunction;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;
import tornadofx.control.skin.MultiSelectSkin;

public final class MultiSelect<E>
extends Control {
    private static final StyleablePropertyFactory<MultiSelect> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private StyleableProperty<Number> hgap = FACTORY.createStyleableNumberProperty((Styleable)this, "hgap", "-fx-hgap", MultiSelect::hgapProperty);
    private StyleableProperty<Number> vgap = FACTORY.createStyleableNumberProperty((Styleable)this, "vgap", "-fx-vgap", MultiSelect::vgapProperty);
    private ObservableList<E> items = FXCollections.observableArrayList();
    private ObjectProperty<BiFunction<MultiSelect<E>, E, Node>> cellFactory = new SimpleObjectProperty();
    private ObjectProperty<Node> editor = new SimpleObjectProperty<Node>(){

        public void set(Node newEditor) {
            Node old = (Node)this.get();
            if (old != null) {
                MultiSelect.this.getChildren().remove((Object)old);
            }
            MultiSelect.this.getChildren().add((Object)newEditor);
            super.set((Object)newEditor);
        }
    };
    private ObjectProperty<StringConverter<E>> converter = new SimpleObjectProperty();

    public ObservableList<E> getItems() {
        return this.items;
    }

    public Number getHgap() {
        return (Number)this.hgap.getValue();
    }

    public void setHgap(Number hgap) {
        this.hgap.setValue((Object)hgap);
    }

    public StyleableProperty<Number> hgapProperty() {
        return this.hgap;
    }

    public Number getVgap() {
        return (Number)this.vgap.getValue();
    }

    public void setVgap(Number vgap) {
        this.vgap.setValue((Object)vgap);
    }

    public StyleableProperty<Number> vgapProperty() {
        return this.vgap;
    }

    public Node getEditor() {
        return (Node)this.editor.get();
    }

    public ObjectProperty<Node> editorProperty() {
        return this.editor;
    }

    public void setEditor(Node editor) {
        this.editor.set((Object)editor);
    }

    public BiFunction<MultiSelect<E>, E, Node> getCellFactory() {
        return (BiFunction)this.cellFactory.get();
    }

    public void setCellFactory(BiFunction<MultiSelect<E>, E, Node> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public ObjectProperty<BiFunction<MultiSelect<E>, E, Node>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public StringConverter<E> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public ObjectProperty<StringConverter<E>> converterProperty() {
        return this.converter;
    }

    public void setConverter(StringConverter<E> converter) {
        this.converter.set(converter);
    }

    public MultiSelect() {
        this.getStyleClass().add((Object)"multi-select");
        this.setFocusTraversable(true);
        this.setEditor((Node)new DefaultEditor(this));
        this.setCellFactory(new DefaultCellFactory());
        this.configureItemChangeListener();
    }

    private void configureItemChangeListener() {
        this.items.addListener(c -> {
            while (c.next()) {
                if (c.wasRemoved()) {
                    this.getChildren().remove(c.getFrom(), c.getTo() + 1);
                }
                if (!c.wasAdded()) continue;
                for (int i = 0; i < c.getAddedSize(); ++i) {
                    Object item = c.getAddedSubList().get(i);
                    Node cell = this.getCellFactory().apply(this, item);
                    this.getChildren().add(i + c.getFrom(), (Object)cell);
                }
            }
        });
    }

    public void addItem(String text) {
        StringConverter<E> c = this.getConverter();
        if (c == null) {
            throw new IllegalArgumentException("You must define a converter before you can add items as Strings");
        }
        Object item = c.fromString(text);
        if (item != null) {
            this.getItems().add(item);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new MultiSelectSkin(this);
    }

    public String getUserAgentStylesheet() {
        return MultiSelect.class.getResource("multiselect.css").toExternalForm();
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public void focusPrevious(Node current) {
        int index = this.getChildren().indexOf((Object)current);
        if (index > 0) {
            Node previous = (Node)this.getChildren().get(index - 1);
            previous.requestFocus();
        }
    }

    private static class DefaultCellFactory<E>
    implements BiFunction<MultiSelect<E>, E, Node> {
        private DefaultCellFactory() {
        }

        @Override
        public Node apply(MultiSelect<E> multiSelect, E item) {
            SplitMenuButton button = new SplitMenuButton();
            button.setText(multiSelect.getConverter().toString(item));
            MenuItem remove = new MenuItem(String.format("Remove %s", item));
            remove.setOnAction(event -> {
                int index = multiSelect.getChildrenUnmodifiable().indexOf((Object)button);
                multiSelect.getItems().remove(item);
                ((Node)multiSelect.getChildrenUnmodifiable().get(index)).requestFocus();
            });
            button.getItems().add((Object)remove);
            button.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                if (event.getCode() == KeyCode.BACK_SPACE) {
                    remove.getOnAction().handle(null);
                }
            });
            return button;
        }
    }

    private static class DefaultEditor
    extends TextField {
        public <E> DefaultEditor(MultiSelect<E> multiSelect) {
            this.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (!(event.getCode() != KeyCode.ENTER && event.getCode() != KeyCode.TAB || this.getText().isEmpty())) {
                    multiSelect.addItem(this.getText());
                    this.setText("");
                }
                if (event.getCode() == KeyCode.BACK_SPACE && this.getText().isEmpty()) {
                    multiSelect.focusPrevious((Node)this);
                }
            });
        }
    }
}

