/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.control;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import tornadofx.control.Fieldset;
import tornadofx.util.NodeHelper;

public abstract class AbstractField
extends Pane {
    SimpleStringProperty textProperty = new SimpleStringProperty();
    private boolean forceLabelIndent = false;
    private Label label = new Label();
    private LabelContainer labelContainer = new LabelContainer(this.label);

    public AbstractField(String text, boolean forceLabelIndent) {
        this.setText(text);
        this.forceLabelIndent = forceLabelIndent;
        this.setFocusTraversable(false);
        this.getStyleClass().add((Object)"field");
        this.label.textProperty().bind((ObservableValue)this.textProperty);
        this.getChildren().add((Object)this.labelContainer);
    }

    public String getText() {
        return this.textProperty.get();
    }

    public void setText(String text) {
        this.textProperty.set(text);
    }

    public void setForceLabelIndent(boolean forceLabelIndent) {
        this.forceLabelIndent = forceLabelIndent;
    }

    public boolean getForceLabelIndent() {
        return this.forceLabelIndent;
    }

    public Fieldset getFieldSet() {
        return NodeHelper.findParentOfType((Node)this, Fieldset.class);
    }

    public abstract Region getInputContainer();

    public abstract ObservableList<Node> getInputs();

    protected double computePrefHeight(double width) {
        double labelHeight = this.labelHasContent() ? this.labelContainer.prefHeight(width) : 0.0;
        double inputHeight = this.getInputContainer().prefHeight(width);
        if (this.isHorizontalLabelPosition()) {
            return Math.max(labelHeight, inputHeight) + this.getVerticalInsets();
        }
        return labelHeight + inputHeight + this.getVerticalInsets();
    }

    protected double computePrefWidth(double height) {
        double labelWidth = this.labelHasContent() ? this.getFieldSet().getForm().getLabelContainerWidth(height) : 0.0;
        double inputWidth = this.getInputContainer().prefWidth(height);
        if (this.isVerticalLabelPosition()) {
            return Math.max(labelWidth, inputWidth) + this.getHorizontalInsets();
        }
        return labelWidth + inputWidth + this.getHorizontalInsets();
    }

    private boolean labelHasContent() {
        return this.forceLabelIndent || this.getText() != null && !this.getText().isEmpty();
    }

    private double getVerticalInsets() {
        return this.getInsets().getTop() + this.getInsets().getBottom();
    }

    private double getHorizontalInsets() {
        return this.getInsets().getLeft() + this.getInsets().getRight();
    }

    private boolean isVerticalLabelPosition() {
        return this.getFieldSet().getLabelPosition().equals((Object)Orientation.VERTICAL);
    }

    private boolean isHorizontalLabelPosition() {
        return !this.isVerticalLabelPosition();
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected void layoutChildren() {
        double contentX = this.getInsets().getLeft();
        double contentY = this.getInsets().getTop();
        double contentWidth = this.getWidth() - this.getHorizontalInsets();
        double contentHeight = this.getHeight() - this.getVerticalInsets();
        double labelWidth = Math.min(contentWidth, this.getFieldSet().getForm().getLabelContainerWidth(this.getHeight()));
        if (this.isHorizontalLabelPosition()) {
            if (this.labelHasContent()) {
                this.labelContainer.resizeRelocate(contentX, contentY, labelWidth, contentHeight);
                double inputX = contentX + labelWidth;
                double inputWidth = contentWidth - labelWidth;
                this.getInputContainer().resizeRelocate(inputX, contentY, inputWidth, contentHeight);
            } else {
                this.getInputContainer().resizeRelocate(contentX, contentY, contentWidth, contentHeight);
            }
        } else if (this.labelHasContent()) {
            double labelPrefHeight = this.labelContainer.prefHeight(this.getWidth());
            double labelHeight = Math.min(labelPrefHeight, contentHeight);
            this.labelContainer.resizeRelocate(contentX, contentY, Math.min(labelWidth, contentWidth), labelHeight);
            double restHeight = contentHeight - labelHeight;
            this.getInputContainer().resizeRelocate(contentX, contentY + labelHeight, contentWidth, restHeight);
        } else {
            this.getInputContainer().resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        }
    }

    public LabelContainer getLabelContainer() {
        return this.labelContainer;
    }

    public Label getLabel() {
        return this.label;
    }

    public class LabelContainer
    extends HBox {
        public LabelContainer(Label label) {
            this.getChildren().add((Object)label);
            this.getStyleClass().add((Object)"label-container");
        }
    }
}

