/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javafx.scene.control.TableView;
import sample.AboutController;
import sample.BaseReportCreator;
import sample.Controller;
import sample.archdata_t;

public class XmlReportCreator
extends BaseReportCreator {
    String template;
    static final String carchtype = "!archType!";
    static final String ccpxnum = "!cpxNum!";
    static final String cpotreb = "!potreb!";
    static final String cpotrebAddr = "!potreb_addr!";
    static final String carchcreated = "!arch_created!";
    static final String caddrows = "!add_rows!";
    static final String crowcount = "!rowcount!";
    static final String carchdate = "!arch_date!";
    static final String csernum = "!csernum!";
    static final String complexName = "!complexName!";
    static final String imeistr = "!imeistr!";
    static final String hwVersion = "!hwVersion!";
    static final String swVersion = "!swVersion!";
    static final String contractHourAndDay = "!contractHourAndDay!";

    XmlReportCreator(TableView<archdata_t> table, long version) {
        super(table, version);
        try {
            String name = "/template.xml";
            if (version >= 2L) {
                name = "/template_v2.xml";
            }
            InputStream tmpl = this.getClass().getResourceAsStream(name);
            byte[] buf = new byte[tmpl.available()];
            tmpl.read(buf);
            this.template = new String(buf, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String GetCell(String data, String type) {
        StringBuilder sb = new StringBuilder("<Cell ss:StyleID=\"s66\"><Data ss:Type=\"");
        sb.append(type);
        sb.append("\">");
        sb.append(data);
        sb.append("</Data></Cell>");
        return sb.toString();
    }

    boolean SaveToFile(String fileName, String archType, String cpxNum, String serNum, String potr, String potrAddr, String archCreated, String archDate, int ctrType, String v2Imei, Integer v2HwVer, String iccid, String contractHour) {
        StringBuilder tc = new StringBuilder(this.template);
        int idx = tc.indexOf(carchtype);
        tc.replace(idx, idx + carchtype.length(), archType);
        idx = tc.indexOf(ccpxnum);
        tc.replace(idx, idx + ccpxnum.length(), cpxNum);
        String sPotr = XmlReportCreator.BuildPotrStr(potr);
        String sPotrAddr = XmlReportCreator.BuildPotrStr(potrAddr);
        idx = tc.indexOf(cpotreb);
        tc.replace(idx, idx + cpotreb.length(), sPotr);
        idx = tc.indexOf(cpotrebAddr);
        tc.replace(idx, idx + cpotrebAddr.length(), sPotrAddr);
        idx = tc.indexOf(carchcreated);
        tc.replace(idx, idx + carchcreated.length(), archCreated);
        idx = tc.indexOf(crowcount);
        int rowcntpref = 11;
        if (this.version >= 2L) {
            rowcntpref = 13;
        }
        Integer rowcnt = rowcntpref + this.table.getItems().size();
        tc.replace(idx, idx + crowcount.length(), rowcnt.toString());
        idx = tc.indexOf(csernum);
        tc.replace(idx, idx + csernum.length(), serNum);
        idx = tc.indexOf(carchdate);
        tc.replace(idx, idx + carchdate.length(), archDate);
        if (this.version >= 2L) {
            idx = tc.indexOf(complexName);
            tc.replace(idx, idx + complexName.length(), XmlReportCreator.GetCompexName(ctrType));
            String sImei = v2Imei.trim();
            idx = tc.indexOf(imeistr);
            if (this.version >= 4L && !iccid.isEmpty()) {
                sImei = sImei + ", ICCID " + iccid.trim();
            }
            tc.replace(idx, idx + imeistr.length(), sImei);
            idx = tc.indexOf(hwVersion);
            tc.replace(idx, idx + hwVersion.length(), XmlReportCreator.GetHwVersion(v2HwVer.longValue()));
            idx = tc.indexOf(swVersion);
            tc.replace(idx, idx + swVersion.length(), AboutController.GetUpVersionStr(Controller.UP_VERSION_HI, Controller.UP_VERSION_LOW, Controller.UP_VERSION_DATE));
            idx = tc.indexOf(contractHourAndDay);
            tc.replace(idx, idx + contractHourAndDay.length(), "\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0439 \u0447\u0430\u0441: " + contractHour);
        }
        StringBuilder rows = new StringBuilder();
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            rows.append("<Row ss:AutoFitHeight=\"1\">");
            if (i == this.table.getItems().size() - 1) {
                rows.append(this.GetCell("\u0418\u0442\u043e\u0433\u043e", "String"));
            } else {
                String s = XmlReportCreator.GetDateRowByType(((archdata_t)this.table.getItems().get((int)i)).archType, ((archdata_t)this.table.getItems().get((int)i)).dt);
                rows.append(this.GetCell(s, "String"));
            }
            rows.append(this.GetCell(String.format(archdata_t.pFormat, ((archdata_t)this.table.getItems().get((int)i)).p).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.tFormat, ((archdata_t)this.table.getItems().get((int)i)).t).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.kFormat, ((archdata_t)this.table.getItems().get((int)i)).k).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vFormat, ((archdata_t)this.table.getItems().get((int)i)).v).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vFormat, ((archdata_t)this.table.getItems().get((int)i)).vall).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vst).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vstall).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vsterr).replace(',', '.'), "Number"));
            rows.append(this.GetCell(String.format(archdata_t.vstFormat, ((archdata_t)this.table.getItems().get((int)i)).vsterrall).replace(',', '.'), "Number"));
            if (i == this.table.getItems().size() - 1) {
                rows.append(this.GetCell("", "String"));
            } else {
                rows.append(this.GetCell(Controller.BuildEventsStringText(((archdata_t)this.table.getItems().get((int)i)).events), "String"));
            }
            rows.append("</Row>");
        }
        idx = tc.indexOf(caddrows);
        tc.replace(idx, idx + caddrows.length(), rows.toString());
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8);
            writer.write(tc.toString());
            writer.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

