/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import sample.Controller;
import tornadofx.control.DateTimePicker;

public class ReportController
implements Initializable {
    public Controller parent;
    public Stage thisStage;
    public VBox reportTab;
    public ComboBox cbArchType;
    public CheckBox chBFromHours;
    public Spinner contractHourSpin;
    public DateTimePicker dtPickerFrom;
    public DateTimePicker dtPickerTo;
    List<String> lcbArchType = new ArrayList<String>();

    public void initialize(URL location, ResourceBundle resources) {
        this.lcbArchType.add("\u0427\u0430\u0441\u043e\u0432\u043e\u0439");
        this.lcbArchType.add("\u0421\u0443\u0442\u043e\u0447\u043d\u044b\u0439");
        this.lcbArchType.add("\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439");
        this.cbArchType.getItems().clear();
        this.cbArchType.setItems(FXCollections.observableList(this.lcbArchType));
        this.cbArchType.setValue((Object)this.lcbArchType.get(0));
        this.chBFromHours.setDisable(true);
        this.contractHourSpin.setDisable(true);
        this.contractHourSpin.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 23, 0));
        this.contractHourSpin.getEditor().setTextFormatter(new TextFormatter(Controller.filterInt));
        this.contractHourSpin.getEditor().lengthProperty().addListener(Controller.NumberLimitsChangeListener(this.contractHourSpin.getEditor(), 0, 23));
        LocalDateTime dtnow = LocalDateTime.now();
        this.dtPickerTo.setDateTimeValue(dtnow);
        this.dtPickerFrom.setDateTimeValue(dtnow.minusMonths(1L));
    }

    public void setParent(Controller c) {
        this.parent = c;
    }

    public void setStage(Stage c) {
        this.thisStage = c;
    }

    public void DoReportClicked(ActionEvent actionEvent) {
        this.thisStage.close();
        int archType = this.cbArchType.getSelectionModel().getSelectedIndex();
        this.parent.ShowLoadedReport(archType, this.dtPickerFrom.getDateTimeValue(), this.dtPickerTo.getDateTimeValue(), Integer.parseInt(this.contractHourSpin.getEditor().getText()), this.chBFromHours.isSelected());
    }

    public void ReportArchTypeChanged(ActionEvent actionEvent) {
        int idx = this.cbArchType.getSelectionModel().getSelectedIndex();
        if (idx == 1) {
            this.chBFromHours.setDisable(false);
            this.contractHourSpin.setDisable(false);
        } else {
            this.chBFromHours.setDisable(true);
            this.contractHourSpin.setDisable(true);
        }
    }
}

