/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.swing.JRViewer;
import sample.AboutController;
import sample.ArchDataReport;
import sample.Controller;
import sample.XmlReportCreator;
import sample.archdata_t;

public class PrintReport
extends JFrame {
    private static final long serialVersionUID = 1L;
    Long version;
    ArrayList<archdata_t> table;
    private static final String emptyDataStr = "---";

    PrintReport(ArrayList<archdata_t> table, Long version) {
        this.setTitle("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043e\u0442\u0447\u0435\u0442\u0430");
        this.table = table;
        this.version = version;
    }

    public void showReport(String archType, String cpxNum, String serNum, String potr, String potrAddr, String archCreated, String archDate, int ctrType, String imei, Long hwVer, String iccid, String contractHour) throws JRException, ClassNotFoundException, SQLException {
        try {
            JasperReport jasperReport = JasperCompileManager.compileReport(this.getClass().getResourceAsStream("/Blank_A4.jrxml"));
            String sPotr = XmlReportCreator.BuildPotrStr(potr);
            String sPotrAddr = XmlReportCreator.BuildPotrStr(potrAddr);
            String sImei = imei.trim();
            String sIccid = iccid.trim();
            Integer errorsCount = 0;
            Long totalEvents = 0L;
            ArrayList<ArchDataReport> listItems = new ArrayList<ArchDataReport>();
            for (int i = 0; i < this.table.size(); ++i) {
                ArchDataReport r = new ArchDataReport();
                String s = "\u0418\u0442\u043e\u0433\u043e";
                if (!this.table.get((int)i).summaryObj.booleanValue()) {
                    if (this.table.get((int)i).archType == 0) {
                        s = Controller.dateTimeDateFormatter.format(this.table.get((int)i).dt) + " " + Controller.dateTimeHourFormatter.format(this.table.get((int)i).dt) + " - " + Controller.dateTimeHourFormatter.format(this.table.get((int)i).dt.plusHours(1L));
                    } else if (this.table.get((int)i).archType == 1) {
                        s = Controller.dateTimeDayFormatter.format(this.table.get((int)i).dt) + " - " + Controller.dateTimeDayFormatter.format(this.table.get((int)i).dt.plusDays(1L));
                    } else if (this.table.get((int)i).archType == 2) {
                        s = Controller.dateTimeMonthFormatter.format(this.table.get((int)i).dt) + " - " + Controller.dateTimeMonthFormatter.format(this.table.get((int)i).dt.plusMonths(1L));
                    }
                }
                r.setDt(s);
                r.setP(this.table.get((int)i).isInited ? String.format(archdata_t.pFormat, this.table.get((int)i).p) : emptyDataStr);
                r.setT(this.table.get((int)i).isInited ? String.format(archdata_t.tFormat, this.table.get((int)i).t) : emptyDataStr);
                r.setK(this.table.get((int)i).isInited ? String.format(archdata_t.kFormat, this.table.get((int)i).k) : emptyDataStr);
                r.setV(this.table.get((int)i).isInited ? String.format(archdata_t.vFormat, this.table.get((int)i).v) : emptyDataStr);
                r.setVst(this.table.get((int)i).isInited ? String.format(archdata_t.vstFormat, this.table.get((int)i).vst) : emptyDataStr);
                r.setVsterr(this.table.get((int)i).isInited ? String.format(archdata_t.vstFormat, this.table.get((int)i).vsterr) : emptyDataStr);
                r.setVall(this.table.get((int)i).isInited && this.table.get((int)i).summaryObj == false ? String.format(archdata_t.vFormat, this.table.get((int)i).vall) : emptyDataStr);
                r.setVstall(this.table.get((int)i).isInited && this.table.get((int)i).summaryObj == false ? String.format(archdata_t.vstFormat, this.table.get((int)i).vstall) : emptyDataStr);
                r.setVsterrall(this.table.get((int)i).isInited && this.table.get((int)i).summaryObj == false ? String.format(archdata_t.vstFormat, this.table.get((int)i).vsterrall) : emptyDataStr);
                r.setError(this.table.get((int)i).isInited && this.table.get((int)i).summaryObj == false ? Controller.BuildEventsString(this.table.get((int)i).events) : emptyDataStr);
                totalEvents = totalEvents | this.table.get((int)i).events;
                if (this.table.get((int)i).events != 0L) {
                    errorsCount = errorsCount + 1;
                }
                listItems.add(r);
            }
            String errorsList = Controller.BuildEventsStringText2(totalEvents);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(listItems);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("ItemDataSource", beanColDataSource);
            parameters.put("Header", archType + " \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u0430\u0440\u0445\u0438\u0432\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u0430 " + XmlReportCreator.GetCompexName(ctrType));
            parameters.put("CpxSerNum", "\u0417\u0430\u0432.\u2116 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u0430 " + cpxNum);
            parameters.put("CorrSerNum", "\u0417\u0430\u0432.\u2116 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430 " + serNum);
            parameters.put("Potreb", "\u041f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u044c: " + sPotr);
            parameters.put("PotrebAddr", "\u0410\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: " + sPotrAddr);
            parameters.put("ArchLoadPeriod", archCreated);
            parameters.put("ArchLoadDateTime", "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: " + archDate);
            parameters.put("ErrorsCount", errorsCount);
            parameters.put("ErrorsList", errorsList);
            if (this.version >= 2L) {
                if (this.version >= 4L) {
                    String extraIccid = "";
                    if (!sIccid.isEmpty()) {
                        extraIccid = ", ICCID: " + sIccid;
                    }
                    parameters.put("IMEI", "IMEI: " + sImei + extraIccid);
                } else {
                    parameters.put("IMEI", "IMEI: " + sImei);
                }
                parameters.put("hwVersion", "\u041d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u041f\u041e: " + XmlReportCreator.GetHwVersion(hwVer));
                parameters.put("contractHourAndDay", "\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0439 \u0447\u0430\u0441: " + contractHour);
            }
            parameters.put("swVersion", AboutController.GetUpVersionStr(Controller.UP_VERSION_HI, Controller.UP_VERSION_LOW, Controller.UP_VERSION_DATE));
            JasperPrint print = JasperFillManager.fillReport(jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
            JRViewer viewer = new JRViewer(print);
            viewer.setOpaque(true);
            viewer.setVisible(true);
            this.add(viewer);
            this.setVisible(true);
            this.setExtendedState(this.getExtendedState() | 6);
            System.out.print("Done!");
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

