/*
 * Decompiled with CFR 0.152.
 */
package sample;

import jssc.SerialPort;
import sample.MBPacket;
import sample.MBState;
import sun.awt.Mutex;

public abstract class ModbusBase {
    protected static final int databuf = 4096;
    protected SerialPort cp;
    protected byte addr;
    protected Mutex mb_lock = new Mutex();

    ModbusBase(SerialPort cp, byte addr) {
        this.cp = cp;
        this.addr = addr;
    }

    public byte GetAddr() {
        return this.addr;
    }

    public SerialPort GetComPort() {
        return this.cp;
    }

    public static short ReverseWord(short word) {
        int ss = word << 8 & 0xFF00 | word >> 8 & 0xFF;
        return (short)ss;
    }

    public static String ToHex(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }

    public abstract MBState Send(MBPacket var1);

    public abstract MBState Read(MBPacket var1) throws InterruptedException;

    public abstract MBState SendAndReadSync(MBPacket var1, MBPacket var2);

    public abstract Boolean isCommandReceived();

    public abstract void ResetReceivedStatus();
}

