/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class GprsMogLog {
    public static final int mogNotSent = 0;
    public static final int mogSentSuccess = 1;
    public static final int mogSentFailedRetry = 2;
    public static final int mogSendScheduled = 3;
    public static final int mogSendScheduleStart = 4;
    public static final int mogSendingNow = 5;
    public static final int GPRS_STAT_NONE = 0;
    public static final int GPRS_STAT_READ_BUFFER = 1;
    public static final int GPRS_STAT_SEND_BUFFER = 2;
    public static final int GPRS_STAT_SEND_RESPONSE = 3;
    public static final int GPRS_STAT_CON_INIT = 4;
    public static final int GPRS_STAT_CTX_INIT = 5;
    public static final int GPRS_STAT_CTX_CLOSE = 6;
    public static final int GPRS_STAT_CTX_INIT_2 = 7;
    public static final int GPRS_STAT_CON_INIT_2 = 8;
    public static final int GPRS_STAT_GET_SERVER_RESP_EX = 9;
    public static final int GPRS_STAT_SEND_ARCH = 10;
    public static final int GPRS_STAT_START_2 = 11;
    public static final int GPRS_STAT_DISABLED = 12;
    public static final int GPRS_STAT_SIM_CHECK_2 = 13;
    public static final int GPRS_STAT_INIT_2 = 14;
    public static final int GPRS_STAT_PIN_CHECK = 15;
    public static final int GPRS_STAT_NETWORK_REG_2 = 16;
    public static final int GPRS_STAT_IDLE_2 = 17;
    public static final int GPRS_STAT_GET_SERVER_RESP = 18;
    public static final int GPRS_STAT_SEND_SERVER_RESP = 19;
    public static final int GPRS_STAT_LIC_INVALID = 20;
    public static final byte gssNone = 0;
    public static final byte gssWorking = 1;
    public static final byte gssFinished = 2;
    public static final byte gssError = 3;
    public byte stage = 0;
    public byte code = 0;
    public byte state = 0;
    public int pos = -1;
    public int total = -1;

    public static String GetMogSchedState(int sched_state) {
        switch (sched_state) {
            case 0: {
                return "\u043d\u0435 \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438";
            }
            case 1: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430";
            }
            case 2: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u043d\u0435\u0443\u0434\u0430\u0447\u0435\u0439";
            }
            case 3: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
            }
            case 4: {
                return "\u0441\u0442\u0430\u0440\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438";
            }
            case 5: {
                return "\u0438\u0434\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430";
            }
        }
        return "<" + sched_state + ">";
    }

    public static String GetMogNextDateTime(Long mog_nextts, DateTimeFormatter dtf) {
        Timestamp ts = new Timestamp(mog_nextts * 1000L);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(ts.toInstant(), ZoneOffset.UTC);
        return zdt.format(dtf);
    }

    public static String GetCodeDescription(byte code) {
        switch (code) {
            case 0: {
                return "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e";
            }
            case 1: {
                return "\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445";
            }
            case 2: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445";
            }
            case 3: {
                return "---";
            }
            case 4: {
                return "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443";
            }
            case 5: {
                return "\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f GPRS, \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443";
            }
            case 6: {
                return "\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f";
            }
            case 7: {
                return "\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f GPRS, \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443";
            }
            case 8: {
                return "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443";
            }
            case 9: {
                return "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
            }
            case 10: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0430\u0440\u0445\u0438\u0432\u043e\u0432 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440";
            }
            case 11: {
                return "\u0441\u0442\u0430\u0440\u0442 \u0437\u0430\u0434\u0430\u0447\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445";
            }
            case 12: {
                return "GPRS \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d (\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430)";
            }
            case 13: {
                return "\u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0441\u0438\u043c-\u043a\u0430\u0440\u0442\u044b";
            }
            case 14: {
                return "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0441\u0432\u044f\u0437\u0438";
            }
            case 15: {
                return "\u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u0438\u043d-\u043a\u043e\u0434\u0430 \u0441\u0438\u043c-\u043a\u0430\u0440\u0442\u044b";
            }
            case 16: {
                return "\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0432 \u0441\u0435\u0442\u0438 \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0439 \u0441\u0432\u044f\u0437\u0438";
            }
            case 17: {
                return "\u0440\u0430\u0431\u043e\u0442\u0430 \u043c\u043e\u0434\u0443\u043b\u044f \u0441\u0432\u044f\u0437\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430";
            }
            case 18: {
                return "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430";
            }
            case 19: {
                return "\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440";
            }
            case 20: {
                return "\u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
            }
        }
        return "<" + code + ">";
    }

    public static String GetMogCurrentStage(GprsMogLog gprs_mog_log) {
        return GprsMogLog.GetCodeDescription(gprs_mog_log.stage);
    }

    public static String GetMogCurrentStatus(GprsMogLog gprs_mog_log) {
        String ret = "";
        if (gprs_mog_log.stage != gprs_mog_log.code) {
            ret = GprsMogLog.GetCodeDescription(gprs_mog_log.code);
        }
        switch (gprs_mog_log.state) {
            case 0: {
                ret = ret + " ---";
                break;
            }
            case 3: {
                ret = ret + " \u043e\u0448\u0438\u0431\u043a\u0430";
                break;
            }
            case 1: {
                ret = ret + " \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f";
                break;
            }
            case 2: {
                ret = ret + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
                break;
            }
            default: {
                ret = ret + " ###";
            }
        }
        if ((gprs_mog_log.code == 1 || gprs_mog_log.code == 2) && gprs_mog_log.pos >= 0 && gprs_mog_log.total >= 0) {
            ret = ret + " (" + gprs_mog_log.pos + ", " + gprs_mog_log.total + ")";
        }
        return ret;
    }
}

