/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class FirmwareVersion
implements Comparable<FirmwareVersion> {
    public int hwLow;
    public int hwHi;
    public int swLow;
    public int swHi;
    public int fullver;
    public boolean isUpdateSupported;
    public boolean isServerSupported;
    public boolean isRemoteSetupSupported;
    public boolean isMqttSupported;

    public FirmwareVersion(int fullVersion) {
        this(fullVersion >> 24 & 0xFF, fullVersion >> 16 & 0xFF, fullVersion >> 8 & 0xFF, fullVersion & 0xFF);
    }

    public FirmwareVersion(int hwhi, int hwlo, int swhi, int swlo) {
        this.hwHi = hwhi;
        this.hwLow = hwlo;
        this.swHi = swhi;
        this.swLow = swlo;
        this.isUpdateSupported = false;
        this.isServerSupported = false;
        this.isMqttSupported = false;
        this.fullver = hwhi << 24 & 0xFF000000 | hwlo << 16 & 0xFF0000 | swhi << 8 & 0xFF00 | swlo & 0xFF;
    }

    public FirmwareVersion(int hwhi, int hwlo, int swhi, int swlo, boolean isUpdateSupported) {
        this(hwhi, hwlo, swhi, swlo);
        this.isUpdateSupported = isUpdateSupported;
        this.isServerSupported = false;
        this.isRemoteSetupSupported = false;
        this.isMqttSupported = false;
    }

    public static int GetFullVerRaw(int hwhi, int hwlo, int swhi, int swlo) {
        return hwhi << 24 & 0xFF000000 | hwlo << 16 & 0xFF0000 | swhi << 8 & 0xFF00 | swlo & 0xFF;
    }

    public FirmwareVersion(int hwhi, int hwlo, int swhi, int swlo, boolean isUpdateSupported, boolean isServerSupported) {
        this(hwhi, hwlo, swhi, swlo);
        this.isUpdateSupported = isUpdateSupported;
        this.isServerSupported = isServerSupported;
        this.isRemoteSetupSupported = false;
        this.isMqttSupported = false;
    }

    public FirmwareVersion(int hwhi, int hwlo, int swhi, int swlo, boolean isUpdateSupported, boolean isServerSupported, boolean isRemoteSetupSupported) {
        this(hwhi, hwlo, swhi, swlo);
        this.isUpdateSupported = isUpdateSupported;
        this.isServerSupported = isServerSupported;
        this.isRemoteSetupSupported = isRemoteSetupSupported;
        this.isMqttSupported = false;
    }

    public FirmwareVersion(int hwhi, int hwlo, int swhi, int swlo, boolean isUpdateSupported, boolean isServerSupported, boolean isRemoteSetupSupported, boolean isMqttSupported) {
        this(hwhi, hwlo, swhi, swlo);
        this.isUpdateSupported = isUpdateSupported;
        this.isServerSupported = isServerSupported;
        this.isRemoteSetupSupported = isRemoteSetupSupported;
        this.isMqttSupported = isMqttSupported;
    }

    @Override
    public int compareTo(FirmwareVersion o) {
        if (o == null) {
            return -1;
        }
        return this.fullver - o.fullver;
    }

    public int hashCode() {
        int result = 31 * this.hwHi + 23 * this.hwLow + 13 * this.swLow + 7 * this.swHi;
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FirmwareVersion)) {
            return false;
        }
        FirmwareVersion ad = (FirmwareVersion)o;
        if (ad == null) {
            return false;
        }
        return this.compareTo(ad) == 0;
    }
}

