/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import sample.FirmwareChecker;
import sample.FirmwareLoaderInfo;

public class FirmwareLoader {
    String path;
    byte[] data;
    String sdata;
    int gsbProcId;
    FirmwareLoaderInfo fwInfo;
    public boolean isWorking;
    boolean isValid = false;

    public FirmwareLoader(String path, int gsbProcId) throws IOException {
        this.path = path;
        this.gsbProcId = gsbProcId;
        this.data = Files.readAllBytes(Paths.get(path, new String[0]));
        this.sdata = new String(this.data, StandardCharsets.US_ASCII);
        this.isWorking = false;
        this.isValid = this.sdata.indexOf("BTHDRS") != -1 && this.sdata.indexOf("BTHDRE") != -1;
        this.fwInfo = this.getInfo();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public FirmwareLoaderInfo getInfo() {
        if (this.fwInfo != null) {
            return this.fwInfo;
        }
        int st = this.sdata.indexOf("BTHDRS");
        int se = this.sdata.indexOf("BTHDRE");
        ByteBuffer bb = ByteBuffer.wrap(this.data);
        bb.position(6);
        int hdrver = Integer.reverseBytes(bb.getInt());
        bb.position(10);
        int fwver = Integer.reverseBytes(bb.getInt());
        bb.position(14);
        int date = Integer.reverseBytes(bb.getInt());
        if (this.gsbProcId == 0) {
            this.isValid = st != -1 && se != -1 && hdrver == 1;
        } else if (this.gsbProcId == 1) {
            this.isValid = st != -1 && se != -1 && hdrver >= 40;
        }
        this.fwInfo = new FirmwareLoaderInfo();
        this.fwInfo.date = date;
        this.fwInfo.fwversion = FirmwareChecker.VersionToString(fwver);
        return this.fwInfo;
    }

    public byte[] getData() {
        return this.data;
    }

    public static String getUpdateStatus(Integer v) {
        if (v == 100) {
            return "\u0443\u0441\u043f\u0435\u0448\u043d\u043e";
        }
        return "\u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u043a\u043e\u0434 " + v.toString();
    }
}

