/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.LinkedList;
import java.util.List;
import sample.FirmwareVersion;

public class FirmwareChecker {
    static List<FirmwareVersion> versions;

    private static void init() {
        if (versions == null) {
            versions = new LinkedList<FirmwareVersion>();
            versions.add(new FirmwareVersion(2, 3, 1, 1, false));
            versions.add(new FirmwareVersion(2, 3, 1, 2, false));
            versions.add(new FirmwareVersion(2, 4, 1, 2, true));
            versions.add(new FirmwareVersion(2, 4, 1, 3, true));
            versions.add(new FirmwareVersion(2, 4, 1, 4, true));
            versions.add(new FirmwareVersion(2, 4, 1, 5, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 0, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 1, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 2, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 3, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 4, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 5, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 6, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 7, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 8, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 9, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 10, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 11, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 0, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 12, true, true));
            versions.add(new FirmwareVersion(2, 4, 2, 13, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 13, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 14, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 15, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 16, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 17, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 18, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 19, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 20, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 21, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 22, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 23, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 24, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 25, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 26, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 26, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 27, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 28, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 29, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 30, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 31, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 32, true, true, true));
            versions.add(new FirmwareVersion(2, 4, 3, 33, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 27, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 28, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 29, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 30, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 31, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 32, true, true, true));
            versions.add(new FirmwareVersion(4, 0, 3, 33, true, true, true));
        }
    }

    static boolean IsConnected(Integer fullVersion) {
        return fullVersion != 0;
    }

    static boolean IsSupportedVersion(Integer fullVersion) {
        FirmwareChecker.init();
        FirmwareVersion v = new FirmwareVersion(fullVersion);
        return versions.indexOf(v) != -1;
    }

    static boolean IsUpdateSupported(Integer fullVersion) {
        FirmwareChecker.init();
        FirmwareVersion v = new FirmwareVersion(fullVersion);
        int idx = versions.indexOf(v);
        if (idx == -1) {
            return fullVersion >= 33816834;
        }
        return FirmwareChecker.versions.get((int)idx).isUpdateSupported;
    }

    static boolean IsServerSupported(Integer fullVersion) {
        FirmwareChecker.init();
        FirmwareVersion v = new FirmwareVersion(fullVersion);
        int idx = versions.indexOf(v);
        if (idx == -1) {
            return fullVersion >= 33816837;
        }
        return FirmwareChecker.versions.get((int)idx).isServerSupported;
    }

    static boolean IsMqttSupported(Integer fullVersion) {
        FirmwareChecker.init();
        FirmwareVersion v = new FirmwareVersion(fullVersion);
        int idx = versions.indexOf(v);
        if (idx == -1) {
            return fullVersion >= 67109664;
        }
        return FirmwareChecker.versions.get((int)idx).isMqttSupported;
    }

    static boolean IsRemoteSetupSupported(Integer fullVersion) {
        FirmwareChecker.init();
        FirmwareVersion v = new FirmwareVersion(fullVersion);
        int idx = versions.indexOf(v);
        if (idx == -1) {
            return fullVersion >= 33817368;
        }
        return FirmwareChecker.versions.get((int)idx).isRemoteSetupSupported;
    }

    public static String VersionToString(Integer version) {
        Integer v1 = version >> 24 & 0xFF;
        Integer v2 = version >> 16 & 0xFF;
        Integer v3 = version >> 8 & 0xFF;
        Integer v4 = version & 0xFF;
        Integer v123 = v1 * 100 + v2 * 10 + v3;
        return v123.toString() + "." + v4.toString();
    }

    public static boolean IsL433Version(Integer version) {
        return version >= 0x4000000;
    }
}

