/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.File;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import sample.Controller;
import sample.ExportParams;
import sample.GprsFileMetaInfo;
import sample.TxtReportCreator;
import sample.XmlReportCreator;
import sample.archdata_t;

public class ExportController
implements Initializable {
    public Controller parent;
    public Stage thisStage;
    public CheckBox chBHour;
    public CheckBox chBDay;
    public CheckBox chBMonth;
    private ExportType expType;
    private GprsFileMetaInfo mdi;
    private TableView<archdata_t> arh;
    private TableView<archdata_t> ard;
    private TableView<archdata_t> arm;
    private LocalDateTime dtminHour;
    private LocalDateTime dtmaxHour;
    private LocalDateTime dtminDay;
    private LocalDateTime dtmaxDay;
    private LocalDateTime dtminMonth;
    private LocalDateTime dtmaxMonth;
    private String complexSN;
    private String counterSN;
    private String potr;
    private String potrAddr;
    private String archLoadDateTime;

    public void SetReportStrings(String complexSN, String counterSN, String potr, String potrAddr, String archLoadDateTime) {
        this.complexSN = complexSN;
        this.counterSN = counterSN;
        this.potr = potr;
        this.potrAddr = potrAddr;
        this.archLoadDateTime = archLoadDateTime;
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void SetDates(LocalDateTime dtminHour, LocalDateTime dtmaxHour, LocalDateTime dtminDay, LocalDateTime dtmaxDay, LocalDateTime dtminMonth, LocalDateTime dtmaxMonth) {
        this.dtminHour = dtminHour;
        this.dtmaxHour = dtmaxHour;
        this.dtminDay = dtminDay;
        this.dtmaxDay = dtmaxDay;
        this.dtminMonth = dtminMonth;
        this.dtmaxMonth = dtmaxMonth;
    }

    public void setParent(Controller c) {
        this.parent = c;
    }

    public void setStage(Stage c) {
        this.thisStage = c;
    }

    public ExportController SetArchDataHour(TableView<archdata_t> archTableHour) {
        this.arh = archTableHour;
        return this;
    }

    public ExportController SetArchDataDay(TableView<archdata_t> archTableDay) {
        this.ard = archTableDay;
        return this;
    }

    public ExportController SetArchDataMonth(TableView<archdata_t> archTableMonth) {
        this.arm = archTableMonth;
        return this;
    }

    public ExportController SetMetaDataInfo(GprsFileMetaInfo mdi) {
        this.mdi = mdi;
        return this;
    }

    public ExportController SetExportType(ExportType type) {
        this.expType = type;
        return this;
    }

    boolean SaveXmlData(String dlgTitle, TableView<archdata_t> table, int archType, String archTypeStr) {
        LocalDateTime dtmax;
        LocalDateTime dtmin;
        XmlReportCreator xml = new XmlReportCreator(table, this.mdi.version);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(dlgTitle);
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("\u0424\u0430\u0439\u043b Excel XML", new String[]{"*.xml"}));
        File f = fileChooser.showSaveDialog(this.thisStage.getScene().getWindow());
        if (f == null) {
            return false;
        }
        if (archType == 0) {
            dtmin = this.dtminHour;
            dtmax = this.dtmaxHour;
        } else if (archType == 1) {
            dtmin = this.dtminDay;
            dtmax = this.dtmaxDay;
        } else {
            dtmin = this.dtminMonth;
            dtmax = this.dtmaxMonth;
        }
        if (dtmin == null) {
            dtmin = LocalDateTime.now();
        }
        if (dtmax == null) {
            dtmax = LocalDateTime.now();
        }
        String archCreated = "\u0410\u0440\u0445\u0438\u0432 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434: \u043e\u0442 " + Controller.dateTimeFormatter.format(dtmin) + " \u0434\u043e " + Controller.dateTimeFormatter.format(dtmax);
        Integer contrHour = this.mdi.contractHour;
        boolean res = xml.SaveToFile(f.getPath(), archTypeStr, this.complexSN, this.counterSN, this.potr, this.potrAddr, archCreated, this.archLoadDateTime, this.mdi.ctrType, this.mdi.imei, new Long(this.mdi.hwVersion).intValue(), this.mdi.iccid, contrHour.toString());
        if (!res) {
            Controller.MessageBox(f.getPath(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430!", Alert.AlertType.WARNING, ButtonType.OK);
        }
        return res;
    }

    boolean SaveTxtData(String dlgTitle, TableView<archdata_t> table, int archType, String archTypeStr) {
        LocalDateTime dtmax;
        LocalDateTime dtmin;
        TxtReportCreator txt = new TxtReportCreator(table, this.mdi.version);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(dlgTitle);
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("\u0422\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0444\u0430\u0439\u043b TXT", new String[]{"*.txt"}));
        File f = fileChooser.showSaveDialog(this.thisStage.getScene().getWindow());
        if (f == null) {
            return false;
        }
        if (archType == 0) {
            dtmin = this.dtminHour;
            dtmax = this.dtmaxHour;
        } else if (archType == 1) {
            dtmin = this.dtminDay;
            dtmax = this.dtmaxDay;
        } else {
            dtmin = this.dtminMonth;
            dtmax = this.dtmaxMonth;
        }
        if (dtmin == null) {
            dtmin = LocalDateTime.now();
        }
        if (dtmax == null) {
            dtmax = LocalDateTime.now();
        }
        String archCreated = "\u0410\u0440\u0445\u0438\u0432 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434: \u043e\u0442 " + Controller.dateTimeFormatter.format(dtmin) + " \u0434\u043e " + Controller.dateTimeFormatter.format(dtmax);
        Integer contrHour = this.mdi.contractHour;
        boolean res = txt.SaveToFile(f.getPath(), archTypeStr, this.complexSN, this.counterSN, this.potr, this.potrAddr, archCreated, this.archLoadDateTime, this.mdi.ctrType, this.mdi.imei, new Long(this.mdi.hwVersion).intValue(), this.mdi.iccid, contrHour.toString());
        if (!res) {
            Controller.MessageBox(f.getPath(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430!", Alert.AlertType.WARNING, ButtonType.OK);
        }
        return res;
    }

    public void BtnSaveClicked(ActionEvent actionEvent) {
        if (this.mdi == null) {
            return;
        }
        ExportParams ep = new ExportParams(this.chBHour.isSelected(), this.chBDay.isSelected(), this.chBMonth.isSelected(), this.expType);
        boolean res = true;
        if (this.expType == ExportType.expTypeXml) {
            if (ep.useArchHour) {
                res &= this.SaveXmlData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0447\u0430\u0441\u043e\u0432\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.arh, 0, "\u0427\u0430\u0441\u043e\u0432\u043e\u0439");
            }
            if (ep.useArchDay) {
                res &= this.SaveXmlData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0441\u0443\u0442\u043e\u0447\u043d\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.ard, 1, "\u0421\u0443\u0442\u043e\u0447\u043d\u044b\u0439");
            }
            if (ep.useArchMonth) {
                res &= this.SaveXmlData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.arm, 2, "\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439");
            }
        } else {
            if (ep.useArchHour) {
                res &= this.SaveTxtData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0447\u0430\u0441\u043e\u0432\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.arh, 0, "\u0427\u0430\u0441\u043e\u0432\u043e\u0439");
            }
            if (ep.useArchDay) {
                res &= this.SaveTxtData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0441\u0443\u0442\u043e\u0447\u043d\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.ard, 1, "\u0421\u0443\u0442\u043e\u0447\u043d\u044b\u0439");
            }
            if (ep.useArchMonth) {
                res &= this.SaveTxtData("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0445 \u0430\u0440\u0445\u0438\u0432\u043e\u0432", this.arm, 2, "\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439");
            }
        }
        if (res) {
            Controller.MessageBox("\u0414\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b!", "", Alert.AlertType.INFORMATION, ButtonType.OK);
        } else {
            Controller.MessageBox("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430!", "", Alert.AlertType.WARNING, ButtonType.OK);
        }
        this.thisStage.close();
    }

    public static enum ExportType {
        expTypeXml,
        expTypeTxt;

    }
}

