/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Stage;
import sample.Controller;
import sample.Gost30319_2;

public class CalcController
implements Initializable {
    public Controller parent;
    public Stage thisStage;
    public TextField ETemp;
    public TextField EPres;
    public TextField EN2;
    public TextField ECO2;
    public TextField EKsgf;
    public TextField ERost;

    public void initialize(URL location, ResourceBundle resources) {
        this.ETemp.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.EPres.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.EN2.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.ECO2.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.ERost.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.EKsgf.setTextFormatter(new TextFormatter(Controller.filterDecimal));
        this.ETemp.focusedProperty().addListener((obs, oldVal, newVal) -> this.focusEvent(this.ETemp, (ObservableValue<? extends Boolean>)obs, (Boolean)oldVal, (Boolean)newVal));
        this.EPres.focusedProperty().addListener((obs, oldVal, newVal) -> this.focusEvent(this.EPres, (ObservableValue<? extends Boolean>)obs, (Boolean)oldVal, (Boolean)newVal));
        this.EN2.focusedProperty().addListener((obs, oldVal, newVal) -> this.focusEvent(this.EN2, (ObservableValue<? extends Boolean>)obs, (Boolean)oldVal, (Boolean)newVal));
        this.ECO2.focusedProperty().addListener((obs, oldVal, newVal) -> this.focusEvent(this.ECO2, (ObservableValue<? extends Boolean>)obs, (Boolean)oldVal, (Boolean)newVal));
        this.ERost.focusedProperty().addListener((obs, oldVal, newVal) -> this.focusEvent(this.ERost, (ObservableValue<? extends Boolean>)obs, (Boolean)oldVal, (Boolean)newVal));
    }

    public void setParent(Controller c) {
        this.parent = c;
    }

    public void setStage(Stage c) {
        this.thisStage = c;
    }

    public void setValues(String temp, String press) {
        this.ETemp.setText(temp);
        this.EPres.setText(press);
    }

    public void CalcBtnClicked(ActionEvent actionEvent) {
        double t = Double.parseDouble(this.ETemp.getText()) + 273.15;
        double p = Double.parseDouble(this.EPres.getText()) / 1000.0;
        double rost = Double.parseDouble(this.ERost.getText());
        double n2 = Double.parseDouble(this.EN2.getText()) / 100.0;
        double co2 = Double.parseDouble(this.ECO2.getText()) / 100.0;
        Double ksgf = Gost30319_2.CalcKsgf(t, p, rost, n2, co2);
        String sk = String.format("%.6f", ksgf);
        sk = sk.replace(',', '.');
        this.EKsgf.setText(sk);
    }

    public void CopyBtnClicked(ActionEvent actionEvent) {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.EKsgf.getText());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    void focusEvent(TextField tf, ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
        if (newPropertyValue.booleanValue()) {
            double v = 0.0;
            if (tf.getText().isEmpty()) {
                return;
            }
            try {
                v = Double.parseDouble(tf.getText());
                if (v == 0.0) {
                    tf.setText("");
                }
            }
            catch (Exception exception) {}
        } else if (tf.getText().isEmpty()) {
            tf.setText("0");
        }
    }
}

