/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import sample.BaseReportCreator;
import sample.Controller;
import sample.FirmwareChecker;

public class AboutController
implements Initializable {
    public Controller parent;
    public Stage thisStage;
    public VBox aboutTab;
    public Hyperlink manufLink;
    public Hyperlink distrLink;
    public Label lblUpVersion;
    public Label lblDownVersion;
    public static DateTimeFormatter dateTimeDayFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    public Label lblImei;
    public Label lblGspType;
    public Label lblCpxNum;
    private String imei;
    private String iccid;

    public void initialize(URL location, ResourceBundle resources) {
        this.imei = "";
        this.iccid = "";
        this.manufLink.setBorder(Border.EMPTY);
        this.manufLink.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
        this.distrLink.setBorder(Border.EMPTY);
        this.distrLink.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
    }

    public void setParent(Controller c) {
        this.parent = c;
    }

    public void setStage(Stage c) {
        this.thisStage = c;
    }

    public static String GetUpVersionStr(Integer versionHi, Integer versionLo, LocalDateTime versionDate) {
        return "\u041d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u0413\u0421\u041f-\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440\u0430: " + versionHi + "." + versionLo + " (" + versionDate.format(dateTimeDayFormatter) + ")";
    }

    public void setUpVersion(Integer versionHi, Integer versionLo, LocalDateTime versionDate) {
        this.lblUpVersion.setText(AboutController.GetUpVersionStr(versionHi, versionLo, versionDate));
    }

    public static String FWVersionToStr(Integer version) {
        return FirmwareChecker.VersionToString(version);
    }

    public void setDownVersion(Integer version, LocalDateTime versionDate) {
        this.lblDownVersion.setText("\u041d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u041f\u041e: " + AboutController.FWVersionToStr(version) + " (" + versionDate.format(dateTimeDayFormatter) + ")");
    }

    public void setCpxNum(Integer cpxNum) {
        this.lblCpxNum.setText("\u0417\u0430\u0432.\u2116 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u0430: " + cpxNum.toString());
    }

    public void setDownGspType(Integer crtType) {
        this.lblGspType.setText("\u0422\u0438\u043f\u043e\u0440\u0430\u0437\u043c\u0435\u0440: " + BaseReportCreator.GetCompexName(crtType));
    }

    public String getCtrType() {
        return this.lblGspType.getText();
    }

    public void manufLinkClicked(ActionEvent actionEvent) {
        try {
            Desktop.getDesktop().browse(new URL("http://www.progress-gs.ru/").toURI());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void setImei(String s) {
        this.imei = s;
        String extraIccid = "";
        if (!this.iccid.isEmpty()) {
            extraIccid = ", ICCID: " + this.iccid;
        }
        this.lblImei.setText("IMEI: " + this.imei + extraIccid);
    }

    public String getImei() {
        return this.imei;
    }

    public void setIccid(String s) {
        this.iccid = s;
        String extraIccid = "";
        if (!this.iccid.isEmpty()) {
            extraIccid = ", ICCID: " + this.iccid;
        }
        this.lblImei.setText("IMEI: " + this.imei + extraIccid);
    }

    public String getIccid() {
        return this.iccid;
    }

    public void distrLinkClicked(ActionEvent actionEvent) {
        try {
            Desktop.getDesktop().browse(new URL("http://www.ooosinkor.ru/").toURI());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

