/*
 * Decompiled with CFR 0.152.
 */
package com.krasutski.util;

import java.lang.reflect.Field;

public final class ReflectionUtils {
    public static Field getField(Object object, String fieldName) {
        try {
            return object.getClass().getDeclaredField(fieldName);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getUnsafeField(Object object, String fieldName) {
        try {
            Field field = ReflectionUtils.getField(object, fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getUnsafeFieldValue(Object object, String fieldName) {
        try {
            Field field = ReflectionUtils.getUnsafeField(object, fieldName);
            return ReflectionUtils.unsafeCast(field.get(object));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T unsafeCast(Object object) {
        return (T)object;
    }

    private ReflectionUtils() {
        throw new IllegalArgumentException();
    }
}

